/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.SimplePrincipal;
import org.jasig.cas.authentication.support.LdapPasswordPolicyConfiguration;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.auth.AuthenticationRequest;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.AuthenticationResultCode;
import org.ldaptive.auth.Authenticator;

public class LdapAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    @NotNull
    private final Authenticator authenticator;
    @NotNull
    private String name = LdapAuthenticationHandler.class.getSimpleName();
    private String principalIdAttribute;
    private boolean allowMultiplePrincipalAttributeValues = false;
    @NotNull
    protected Map<String, String> principalAttributeMap = Collections.emptyMap();
    @NotNull
    protected List<String> additionalAttributes = Collections.emptyList();
    private String[] authenticatedEntryAttributes;

    public LdapAuthenticationHandler(@NotNull Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPrincipalIdAttribute(String attributeName) {
        this.principalIdAttribute = attributeName;
    }

    public void setAllowMultiplePrincipalAttributeValues(boolean allowed) {
        this.allowMultiplePrincipalAttributeValues = allowed;
    }

    public void setPrincipalAttributeMap(Map<String, String> attributeNameMap) {
        this.principalAttributeMap = attributeNameMap;
    }

    public void setAdditionalAttributes(List<String> additionalAttributes) {
        this.additionalAttributes = additionalAttributes;
    }

    protected HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential upc) throws GeneralSecurityException, PreventedException {
        List<Object> messageList;
        AuthenticationResponse response;
        try {
            this.logger.debug("Attempting LDAP authentication for {}", (Object)upc);
            AuthenticationRequest request = new AuthenticationRequest(upc.getUsername(), new org.ldaptive.Credential(upc.getPassword()), this.authenticatedEntryAttributes);
            response = this.authenticator.authenticate(request);
        }
        catch (LdapException e) {
            throw new PreventedException("Unexpected LDAP error", (Throwable)e);
        }
        this.logger.debug("LDAP response: {}", (Object)response);
        LdapPasswordPolicyConfiguration ldapPasswordPolicyConfiguration = (LdapPasswordPolicyConfiguration)super.getPasswordPolicyConfiguration();
        if (ldapPasswordPolicyConfiguration != null) {
            this.logger.debug("Applying password policy to {}", (Object)response);
            messageList = ldapPasswordPolicyConfiguration.getAccountStateHandler().handle(response, ldapPasswordPolicyConfiguration);
        } else {
            messageList = Collections.emptyList();
        }
        if (((Boolean)response.getResult()).booleanValue()) {
            return this.createHandlerResult((Credential)upc, this.createPrincipal(upc.getUsername(), response.getLdapEntry()), messageList);
        }
        if (AuthenticationResultCode.DN_RESOLUTION_FAILURE == response.getAuthenticationResultCode()) {
            throw new AccountNotFoundException(upc.getUsername() + " not found.");
        }
        throw new FailedLoginException("Invalid credentials.");
    }

    public boolean supports(Credential credential) {
        return credential instanceof UsernamePasswordCredential;
    }

    public String getName() {
        return this.name;
    }

    protected Principal createPrincipal(String username, LdapEntry ldapEntry) throws LoginException {
        String id;
        if (this.principalIdAttribute != null) {
            LdapAttribute principalAttr = ldapEntry.getAttribute(this.principalIdAttribute);
            if (principalAttr == null || principalAttr.size() == 0) {
                throw new LoginException(this.principalIdAttribute + " attribute not found for " + username);
            }
            if (principalAttr.size() > 1) {
                if (this.allowMultiplePrincipalAttributeValues) {
                    this.logger.warn("Found multiple values for principal ID attribute: {}. Using first value={}.", (Object)principalAttr, (Object)principalAttr.getStringValue());
                } else {
                    throw new LoginException("Multiple principal values not allowed: " + principalAttr);
                }
            }
            id = principalAttr.getStringValue();
        } else {
            id = username;
        }
        LinkedHashMap<String, Object> attributeMap = new LinkedHashMap<String, Object>(this.principalAttributeMap.size());
        for (String ldapAttrName : this.principalAttributeMap.keySet()) {
            LdapAttribute attr = ldapEntry.getAttribute(ldapAttrName);
            if (attr == null) continue;
            this.logger.debug("Found principal attribute: {}", (Object)attr);
            String principalAttrName = this.principalAttributeMap.get(ldapAttrName);
            if (attr.size() > 1) {
                attributeMap.put(principalAttrName, attr.getStringValues());
                continue;
            }
            attributeMap.put(principalAttrName, attr.getStringValue());
        }
        return new SimplePrincipal(id, attributeMap);
    }

    @PostConstruct
    public void initialize() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (this.principalIdAttribute != null) {
            attributes.add(this.principalIdAttribute);
        }
        attributes.addAll(this.principalAttributeMap.keySet());
        attributes.addAll(this.additionalAttributes);
        this.authenticatedEntryAttributes = attributes.toArray(new String[attributes.size()]);
    }
}

