/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.ldap.services;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.validation.constraints.NotNull;
import org.jasig.cas.adaptors.ldap.services.LdapRegisteredServiceMapper;
import org.jasig.cas.services.AbstractRegisteredService;
import org.jasig.cas.services.RegexRegisteredService;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.RegisteredServiceImpl;
import org.jasig.cas.util.JsonSerializer;
import org.jasig.cas.util.LdapUtils;
import org.jasig.cas.util.services.RegisteredServiceJsonSerializer;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;

public final class DefaultLdapRegisteredServiceMapper
implements LdapRegisteredServiceMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLdapRegisteredServiceMapper.class);
    @NotNull
    private JsonSerializer<RegisteredService> jsonSerializer = new RegisteredServiceJsonSerializer();
    @NotNull
    private String objectClass = "casRegisteredService";
    @NotNull
    private String idAttribute = "uid";
    @NotNull
    private String serviceDefinitionAttribute = "description";

    @Override
    public LdapEntry mapFromRegisteredService(String dn, RegisteredService svc) {
        try {
            if (svc.getId() == -9223372036854775807L) {
                ((AbstractRegisteredService)svc).setId(System.nanoTime());
            }
            String newDn = this.getDnForRegisteredService(dn, svc);
            LOGGER.debug("Creating entry {}", (Object)newDn);
            ArrayList<LdapAttribute> attrs = new ArrayList<LdapAttribute>();
            attrs.add(new LdapAttribute(this.idAttribute, new String[]{String.valueOf(svc.getId())}));
            StringWriter writer = new StringWriter();
            this.jsonSerializer.toJson((Writer)writer, (Object)svc);
            attrs.add(new LdapAttribute(this.serviceDefinitionAttribute, new String[]{writer.toString()}));
            attrs.add(new LdapAttribute("objectClass", new String[]{"top", this.objectClass}));
            return new LdapEntry(newDn, attrs);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RegisteredService mapToRegisteredService(LdapEntry entry) {
        try {
            String value = LdapUtils.getString(entry, this.serviceDefinitionAttribute);
            if (StringUtils.hasText((String)value)) {
                RegisteredService service = (RegisteredService)this.jsonSerializer.fromJson(value);
                return service;
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(String objectClass) {
        this.objectClass = objectClass;
    }

    @Override
    public String getIdAttribute() {
        return this.idAttribute;
    }

    public void setIdAttribute(String idAttribute) {
        this.idAttribute = idAttribute;
    }

    public String getServiceDefinitionAttribute() {
        return this.serviceDefinitionAttribute;
    }

    public void setServiceDefinitionAttribute(String serviceDefinitionAttribute) {
        this.serviceDefinitionAttribute = serviceDefinitionAttribute;
    }

    public void setJsonSerializer(JsonSerializer<RegisteredService> jsonSerializer) {
        this.jsonSerializer = jsonSerializer;
    }

    @Override
    public String getDnForRegisteredService(String parentDn, RegisteredService svc) {
        return String.format("%s=%s,%s", this.idAttribute, svc.getId(), parentDn);
    }

    private boolean isValidRegexPattern(String pattern) {
        try {
            Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            LOGGER.debug("Failed to identify [{}] as a regular expression", (Object)pattern);
            return false;
        }
        return true;
    }

    private Collection<String> getMultiValuedAttributeValues(@NotNull LdapEntry entry, @NotNull String attrName) {
        LdapAttribute attrs = entry.getAttribute(attrName);
        if (attrs != null) {
            return attrs.getStringValues();
        }
        return Collections.emptyList();
    }

    private AbstractRegisteredService getRegisteredService(@NotNull String id) {
        if (this.isValidRegexPattern(id)) {
            return new RegexRegisteredService();
        }
        if (new AntPathMatcher().isPattern(id)) {
            return new RegisteredServiceImpl();
        }
        return null;
    }
}

