/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.ldap.services;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotNull;
import org.jasig.cas.adaptors.ldap.services.DefaultLdapRegisteredServiceMapper;
import org.jasig.cas.adaptors.ldap.services.LdapRegisteredServiceMapper;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServiceRegistryDao;
import org.jasig.cas.util.LdapUtils;
import org.ldaptive.AddOperation;
import org.ldaptive.AddRequest;
import org.ldaptive.AttributeModification;
import org.ldaptive.AttributeModificationType;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.DeleteOperation;
import org.ldaptive.DeleteRequest;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.ModifyOperation;
import org.ldaptive.ModifyRequest;
import org.ldaptive.Request;
import org.ldaptive.Response;
import org.ldaptive.ResultCode;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LdapServiceRegistryDao
implements ServiceRegistryDao {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private ConnectionFactory connectionFactory;
    @NotNull
    private LdapRegisteredServiceMapper ldapServiceMapper = new DefaultLdapRegisteredServiceMapper();
    @NotNull
    private String searchFilter;
    @NotNull
    private String loadFilter;
    @NotNull
    private SearchRequest searchRequest;

    @PostConstruct
    public void init() {
        this.searchFilter = '(' + this.ldapServiceMapper.getIdAttribute() + "={0})";
        this.loadFilter = "(objectClass=" + this.ldapServiceMapper.getObjectClass() + ')';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisteredService save(RegisteredService rs) {
        if (rs.getId() != -9223372036854775807L) {
            return this.update(rs);
        }
        Connection connection = null;
        try {
            connection = this.getConnection();
            AddOperation operation = new AddOperation(connection);
            LdapEntry entry = this.ldapServiceMapper.mapFromRegisteredService(this.searchRequest.getBaseDn(), rs);
            operation.execute((Request)new AddRequest(entry.getDn(), entry.getAttributes()));
        }
        catch (LdapException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            LdapUtils.closeConnection(connection);
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegisteredService update(RegisteredService rs) {
        block11: {
            Connection searchConnection = null;
            try {
                searchConnection = this.getConnection();
                Response<SearchResult> response = this.searchForServiceById(searchConnection, rs.getId());
                if (!this.hasResults(response)) break block11;
                String currentDn = ((SearchResult)response.getResult()).getEntry().getDn();
                Connection modifyConnection = null;
                try {
                    modifyConnection = this.getConnection();
                    ModifyOperation operation = new ModifyOperation(searchConnection);
                    ArrayList<AttributeModification> mods = new ArrayList<AttributeModification>();
                    LdapEntry entry = this.ldapServiceMapper.mapFromRegisteredService(this.searchRequest.getBaseDn(), rs);
                    for (LdapAttribute attr : entry.getAttributes()) {
                        if (attr.getName().equals(this.ldapServiceMapper.getIdAttribute())) continue;
                        mods.add(new AttributeModification(AttributeModificationType.REPLACE, attr));
                    }
                    ModifyRequest request = new ModifyRequest(currentDn, mods.toArray(new AttributeModification[0]));
                    operation.execute((Request)request);
                }
                catch (LdapException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
                finally {
                    LdapUtils.closeConnection(modifyConnection);
                }
            }
            catch (LdapException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                LdapUtils.closeConnection(searchConnection);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(RegisteredService registeredService) {
        Connection connection = null;
        try {
            connection = this.getConnection();
            Response<SearchResult> response = this.searchForServiceById(connection, registeredService.getId());
            if (this.hasResults(response)) {
                DeleteOperation delete = new DeleteOperation(connection);
                LdapEntry entry = ((SearchResult)response.getResult()).getEntry();
                DeleteRequest request = new DeleteRequest(entry.getDn());
                Response res = delete.execute((Request)request);
                boolean bl = res.getResultCode() == ResultCode.SUCCESS;
                return bl;
            }
        }
        catch (LdapException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            LdapUtils.closeConnection(connection);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RegisteredService> load() {
        Connection connection = null;
        LinkedList<RegisteredService> list = new LinkedList<RegisteredService>();
        try {
            connection = this.getConnection();
            Response<SearchResult> response = this.executeSearchOperation(connection, new SearchFilter(this.loadFilter));
            if (this.hasResults(response)) {
                for (LdapEntry entry : ((SearchResult)response.getResult()).getEntries()) {
                    RegisteredService svc = this.ldapServiceMapper.mapToRegisteredService(entry);
                    list.add(svc);
                }
            }
        }
        catch (LdapException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            LdapUtils.closeConnection(connection);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisteredService findServiceById(long id) {
        Connection connection = null;
        try {
            connection = this.getConnection();
            Response<SearchResult> response = this.searchForServiceById(connection, id);
            if (this.hasResults(response)) {
                RegisteredService registeredService = this.ldapServiceMapper.mapToRegisteredService(((SearchResult)response.getResult()).getEntry());
                return registeredService;
            }
        }
        catch (LdapException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            LdapUtils.closeConnection(connection);
        }
        return null;
    }

    private Response<SearchResult> searchForServiceById(Connection connection, long id) throws LdapException {
        SearchFilter filter = new SearchFilter(this.searchFilter);
        filter.setParameter(0, (Object)id);
        return this.executeSearchOperation(connection, filter);
    }

    private Response<SearchResult> executeSearchOperation(Connection connection, SearchFilter filter) throws LdapException {
        SearchOperation searchOperation = new SearchOperation(connection);
        SearchRequest request = this.newRequest(filter);
        this.logger.debug("Using search request {}", (Object)request.toString());
        return searchOperation.execute((Request)request);
    }

    public void setConnectionFactory(@NotNull ConnectionFactory factory) {
        this.connectionFactory = factory;
    }

    public void setLdapServiceMapper(LdapRegisteredServiceMapper ldapServiceMapper) {
        this.ldapServiceMapper = ldapServiceMapper;
    }

    public void setSearchRequest(@NotNull SearchRequest request) {
        this.searchRequest = request;
    }

    private boolean hasResults(Response<SearchResult> response) {
        SearchResult result = (SearchResult)response.getResult();
        if (result != null && result.getEntry() != null) {
            return true;
        }
        this.logger.trace("Requested ldap operation did not return a result or an ldap entry. Code: {}, Message: {}", (Object)response.getResultCode(), (Object)response.getMessage());
        return false;
    }

    private SearchRequest newRequest(SearchFilter filter) {
        SearchRequest sr = new SearchRequest(this.searchRequest.getBaseDn(), filter);
        sr.setBinaryAttributes(ReturnAttributes.ALL_USER.value());
        sr.setDerefAliases(this.searchRequest.getDerefAliases());
        sr.setSearchEntryHandlers(this.searchRequest.getSearchEntryHandlers());
        sr.setSearchReferenceHandlers(this.searchRequest.getSearchReferenceHandlers());
        sr.setFollowReferrals(this.searchRequest.getFollowReferrals());
        sr.setReturnAttributes(ReturnAttributes.ALL_USER.value());
        sr.setSearchScope(this.searchRequest.getSearchScope());
        sr.setSizeLimit(this.searchRequest.getSizeLimit());
        sr.setSortBehavior(this.searchRequest.getSortBehavior());
        sr.setTimeLimit(this.searchRequest.getTimeLimit());
        sr.setTypesOnly(this.searchRequest.getTypesOnly());
        sr.setControls(this.searchRequest.getControls());
        return sr;
    }

    private Connection getConnection() throws LdapException {
        Connection c = this.connectionFactory.getConnection();
        if (!c.isOpen()) {
            c.open();
        }
        return c;
    }
}

