/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.AccountLockedException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.LoginException;
import org.jasig.cas.DefaultMessageDescriptor;
import org.jasig.cas.MessageDescriptor;
import org.jasig.cas.authentication.AccountDisabledException;
import org.jasig.cas.authentication.AccountPasswordMustChangeException;
import org.jasig.cas.authentication.InvalidLoginLocationException;
import org.jasig.cas.authentication.InvalidLoginTimeException;
import org.jasig.cas.authentication.support.AccountStateHandler;
import org.jasig.cas.authentication.support.LdapPasswordPolicyConfiguration;
import org.jasig.cas.authentication.support.PasswordExpiringWarningMessageDescriptor;
import org.joda.time.Days;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.ldaptive.auth.AccountState;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.ext.ActiveDirectoryAccountState;
import org.ldaptive.auth.ext.EDirectoryAccountState;
import org.ldaptive.auth.ext.PasswordExpirationAccountState;
import org.ldaptive.control.PasswordPolicyControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAccountStateHandler
implements AccountStateHandler {
    protected final Map<AccountState.Error, LoginException> errorMap;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public DefaultAccountStateHandler() {
        this.errorMap = new HashMap<AccountState.Error, LoginException>();
        this.errorMap.put((AccountState.Error)ActiveDirectoryAccountState.Error.ACCOUNT_DISABLED, (LoginException)new AccountDisabledException());
        this.errorMap.put((AccountState.Error)ActiveDirectoryAccountState.Error.ACCOUNT_LOCKED_OUT, new AccountLockedException());
        this.errorMap.put((AccountState.Error)ActiveDirectoryAccountState.Error.INVALID_LOGON_HOURS, (LoginException)new InvalidLoginTimeException());
        this.errorMap.put((AccountState.Error)ActiveDirectoryAccountState.Error.INVALID_WORKSTATION, (LoginException)new InvalidLoginLocationException());
        this.errorMap.put((AccountState.Error)ActiveDirectoryAccountState.Error.PASSWORD_MUST_CHANGE, (LoginException)new AccountPasswordMustChangeException());
        this.errorMap.put((AccountState.Error)ActiveDirectoryAccountState.Error.PASSWORD_EXPIRED, new CredentialExpiredException());
        this.errorMap.put((AccountState.Error)EDirectoryAccountState.Error.ACCOUNT_EXPIRED, new AccountExpiredException());
        this.errorMap.put((AccountState.Error)EDirectoryAccountState.Error.LOGIN_LOCKOUT, new AccountLockedException());
        this.errorMap.put((AccountState.Error)EDirectoryAccountState.Error.LOGIN_TIME_LIMITED, (LoginException)new InvalidLoginTimeException());
        this.errorMap.put((AccountState.Error)EDirectoryAccountState.Error.PASSWORD_EXPIRED, new CredentialExpiredException());
        this.errorMap.put((AccountState.Error)PasswordExpirationAccountState.Error.PASSWORD_EXPIRED, new CredentialExpiredException());
        this.errorMap.put((AccountState.Error)PasswordPolicyControl.Error.ACCOUNT_LOCKED, new AccountLockedException());
        this.errorMap.put((AccountState.Error)PasswordPolicyControl.Error.PASSWORD_EXPIRED, new CredentialExpiredException());
        this.errorMap.put((AccountState.Error)PasswordPolicyControl.Error.CHANGE_AFTER_RESET, new CredentialExpiredException());
    }

    @Override
    public List<MessageDescriptor> handle(AuthenticationResponse response, LdapPasswordPolicyConfiguration configuration) throws LoginException {
        AccountState state = response.getAccountState();
        if (state == null) {
            this.logger.debug("Account state not defined. Returning empty list of messages.");
            return Collections.emptyList();
        }
        ArrayList<MessageDescriptor> messages = new ArrayList<MessageDescriptor>();
        this.handleError(state.getError(), response, configuration, messages);
        this.handleWarning(state.getWarning(), response, configuration, messages);
        return messages;
    }

    protected void handleError(AccountState.Error error, AuthenticationResponse response, LdapPasswordPolicyConfiguration configuration, List<MessageDescriptor> messages) throws LoginException {
        this.logger.debug("Handling error {}", (Object)error);
        LoginException ex = this.errorMap.get(error);
        if (ex != null) {
            throw ex;
        }
        this.logger.debug("No LDAP error mapping defined for {}", (Object)error);
    }

    protected void handleWarning(AccountState.Warning warning, AuthenticationResponse response, LdapPasswordPolicyConfiguration configuration, List<MessageDescriptor> messages) {
        this.logger.debug("Handling warning {}", (Object)warning);
        if (warning == null) {
            this.logger.debug("Account state warning not defined");
            return;
        }
        Calendar expDate = warning.getExpiration();
        Days ttl = Days.daysBetween((ReadableInstant)Instant.now(), (ReadableInstant)new Instant((Object)expDate));
        this.logger.debug("Password expires in {} days. Expiration warning threshold is {} days.", (Object)ttl.getDays(), (Object)configuration.getPasswordWarningNumberOfDays());
        if (configuration.isAlwaysDisplayPasswordExpirationWarning() || ttl.getDays() < configuration.getPasswordWarningNumberOfDays()) {
            messages.add((MessageDescriptor)new PasswordExpiringWarningMessageDescriptor("Password expires in {0} days. Please change your password at <href=\"{1}\">{1}</a>", (long)ttl.getDays(), configuration.getPasswordPolicyUrl()));
        }
        if (warning.getLoginsRemaining() > 0) {
            messages.add((MessageDescriptor)new DefaultMessageDescriptor("password.expiration.loginsRemaining", "You have {0} logins remaining before you MUST change your password.", new Serializable[]{Integer.valueOf(warning.getLoginsRemaining())}));
        }
    }
}

