/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import java.security.GeneralSecurityException;
import javax.security.auth.login.FailedLoginException;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.BasicCredentialMetaData;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.CredentialMetaData;
import org.jasig.cas.authentication.CredentialsAdapter;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.UsernamePasswordCredentialsAdapter;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.handler.AuthenticationHandler;
import org.jasig.cas.authentication.handler.NamedAuthenticationHandler;
import org.jasig.cas.authentication.principal.UsernamePasswordCredentials;

public class LegacyAuthenticationHandlerAdapter
implements org.jasig.cas.authentication.AuthenticationHandler {
    @NotNull
    private final AuthenticationHandler legacyHandler;
    @NotNull
    private final CredentialsAdapter credentialsAdapter;

    public LegacyAuthenticationHandlerAdapter(AuthenticationHandler legacy) {
        if (!legacy.supports(new UsernamePasswordCredentials())) {
            throw new IllegalArgumentException("Cannot infer credential conversion strategy - specify CredentialsAdapter explicitly.");
        }
        this.legacyHandler = legacy;
        this.credentialsAdapter = new UsernamePasswordCredentialsAdapter();
    }

    public LegacyAuthenticationHandlerAdapter(AuthenticationHandler legacy, CredentialsAdapter adapter) {
        this.legacyHandler = legacy;
        this.credentialsAdapter = adapter;
    }

    public HandlerResult authenticate(Credential credential) throws GeneralSecurityException, PreventedException {
        try {
            if (this.legacyHandler.authenticate(this.credentialsAdapter.convert(credential))) {
                Object md = credential instanceof CredentialMetaData ? (CredentialMetaData)credential : new BasicCredentialMetaData(credential);
                return new HandlerResult((org.jasig.cas.authentication.AuthenticationHandler)this, md);
            }
            throw new FailedLoginException(String.format("%s failed to authenticate %s", this.getName(), credential));
        }
        catch (AuthenticationException e) {
            throw new GeneralSecurityException(String.format("%s failed to authenticate %s", this.getName(), credential), e);
        }
    }

    public boolean supports(Credential credential) {
        return this.legacyHandler.supports(this.credentialsAdapter.convert(credential));
    }

    public String getName() {
        if (this.legacyHandler instanceof NamedAuthenticationHandler) {
            return ((NamedAuthenticationHandler)this.legacyHandler).getName();
        }
        return this.legacyHandler.getClass().getSimpleName();
    }
}

