/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.oauth.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.support.oauth.OAuthUtils;
import org.jasig.cas.support.oauth.services.OAuthRegisteredService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public final class OAuth20AuthorizeController
extends AbstractController {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20AuthorizeController.class);
    private final String loginUrl;
    private final ServicesManager servicesManager;

    public OAuth20AuthorizeController(ServicesManager servicesManager, String loginUrl) {
        this.servicesManager = servicesManager;
        this.loginUrl = loginUrl;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String clientId = request.getParameter("client_id");
        LOGGER.debug("{} : {}", (Object)"client_id", (Object)clientId);
        String redirectUri = request.getParameter("redirect_uri");
        LOGGER.debug("{} : {}", (Object)"redirect_uri", (Object)redirectUri);
        String state = request.getParameter("state");
        LOGGER.debug("{} : {}", (Object)"state", (Object)state);
        if (StringUtils.isBlank((CharSequence)clientId)) {
            LOGGER.error("Missing {}", (Object)"client_id");
            return new ModelAndView("viewServiceErrorView");
        }
        if (StringUtils.isBlank((CharSequence)redirectUri)) {
            LOGGER.error("Missing {}", (Object)"redirect_uri");
            return new ModelAndView("viewServiceErrorView");
        }
        OAuthRegisteredService service = OAuthUtils.getRegisteredOAuthService(this.servicesManager, clientId);
        if (service == null) {
            LOGGER.error("Unknown {} : {}", (Object)"client_id", (Object)clientId);
            return new ModelAndView("viewServiceErrorView");
        }
        String serviceId = service.getServiceId();
        if (!redirectUri.matches(serviceId)) {
            LOGGER.error("Unsupported {} : {} for serviceId : {}", new Object[]{"redirect_uri", redirectUri, serviceId});
            return new ModelAndView("viewServiceErrorView");
        }
        HttpSession session = request.getSession();
        session.setAttribute("oauth20_callbackUrl", (Object)redirectUri);
        session.setAttribute("oauth20_service_name", (Object)service.getName());
        session.setAttribute("bypass_approval_prompt", (Object)service.isBypassApprovalPrompt());
        session.setAttribute("oauth20_state", (Object)state);
        String callbackAuthorizeUrl = request.getRequestURL().toString().replace("/authorize", "/callbackAuthorize");
        LOGGER.debug("{} : {}", (Object)"callbackAuthorize", (Object)callbackAuthorizeUrl);
        String loginUrlWithService = OAuthUtils.addParameter(this.loginUrl, "service", callbackAuthorizeUrl);
        LOGGER.debug("loginUrlWithService : {}", (Object)loginUrlWithService);
        return OAuthUtils.redirectTo(loginUrlWithService);
    }
}

