/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.oauth.web;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.support.oauth.OAuthUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public final class OAuth20CallbackAuthorizeController
extends AbstractController {
    private final Logger logger = LoggerFactory.getLogger(OAuth20CallbackAuthorizeController.class);

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String ticket = request.getParameter("ticket");
        this.logger.debug("{} : {}", (Object)"ticket", (Object)ticket);
        HttpSession session = request.getSession();
        String callbackUrl = (String)session.getAttribute("oauth20_callbackUrl");
        this.logger.debug("{} : {}", (Object)"oauth20_callbackUrl", (Object)callbackUrl);
        session.removeAttribute("oauth20_callbackUrl");
        if (StringUtils.isBlank((CharSequence)callbackUrl)) {
            this.logger.error("{} is missing from the session and can not be retrieved.", (Object)"oauth20_callbackUrl");
            return new ModelAndView("viewServiceErrorView");
        }
        String state = (String)session.getAttribute("oauth20_state");
        this.logger.debug("{} : {}", (Object)"oauth20_state", (Object)state);
        session.removeAttribute("oauth20_state");
        callbackUrl = OAuthUtils.addParameter(callbackUrl, "code", ticket);
        if (state != null) {
            callbackUrl = OAuthUtils.addParameter(callbackUrl, "state", state);
        }
        this.logger.debug("{} : {}", (Object)"oauth20_callbackUrl", (Object)callbackUrl);
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("callbackUrl", callbackUrl);
        Boolean bypassApprovalPrompt = (Boolean)session.getAttribute("bypass_approval_prompt");
        this.logger.debug("bypassApprovalPrompt : {}", (Object)bypassApprovalPrompt);
        session.removeAttribute("bypass_approval_prompt");
        if (bypassApprovalPrompt != null && bypassApprovalPrompt.booleanValue()) {
            return OAuthUtils.redirectTo(callbackUrl);
        }
        String serviceName = (String)session.getAttribute("oauth20_service_name");
        this.logger.debug("serviceName : {}", (Object)serviceName);
        model.put("serviceName", serviceName);
        return new ModelAndView("oauthConfirmView", model);
    }
}

