/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.pac4j.web.flow;

import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.AuthenticationContext;
import org.jasig.cas.authentication.AuthenticationContextBuilder;
import org.jasig.cas.authentication.AuthenticationSystemSupport;
import org.jasig.cas.authentication.AuthenticationTransaction;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.DefaultAuthenticationContextBuilder;
import org.jasig.cas.authentication.DefaultAuthenticationSystemSupport;
import org.jasig.cas.authentication.principal.ClientCredential;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.support.pac4j.web.flow.ClientAction$AjcClosure1;
import org.jasig.cas.support.pac4j.web.flow.ClientAction$AjcClosure3;
import org.jasig.cas.support.pac4j.web.flow.ClientAction$AjcClosure5;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.web.support.WebUtils;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.ClientType;
import org.pac4j.core.client.Clients;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.RequiresHttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.ProfileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

@Component(value="clientAction")
public final class ClientAction
extends AbstractAction {
    public static final String PAC4J_URLS = "pac4jUrls";
    private static final Set<ClientType> SUPPORTED_PROTOCOLS;
    private final transient Logger logger = LoggerFactory.getLogger(ClientAction.class);
    @NotNull
    @Autowired
    @Qualifier(value="builtClients")
    private Clients clients;
    @NotNull
    @Autowired(required=false)
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private AuthenticationSystemSupport authenticationSystemSupport = new DefaultAuthenticationSystemSupport();
    @NotNull
    @Autowired
    private CentralAuthenticationService centralAuthenticationService;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    static {
        ClientAction.ajc$preClinit();
        SUPPORTED_PROTOCOLS = ImmutableSet.of((Object)ClientType.CAS_PROTOCOL, (Object)ClientType.OAUTH_PROTOCOL, (Object)ClientType.OPENID_PROTOCOL, (Object)ClientType.SAML_PROTOCOL, (Object)ClientType.OPENID_CONNECT_PROTOCOL);
        ProfileHelper.setKeepRawData((boolean)true);
    }

    protected Event doExecute(RequestContext context) throws Exception {
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)context);
        HttpServletResponse response = WebUtils.getHttpServletResponse((RequestContext)context);
        HttpSession session = request.getSession();
        J2EContext webContext = new J2EContext(request, response);
        String clientName = request.getParameter(this.clients.getClientNameParameter());
        this.logger.debug("clientName: {}", (Object)clientName);
        if (StringUtils.isNotBlank((CharSequence)clientName)) {
            Credentials credentials;
            BaseClient client = (BaseClient)this.clients.findClient(clientName);
            this.logger.debug("client: {}", (Object)client);
            ClientType clientType = client.getClientType();
            if (!SUPPORTED_PROTOCOLS.contains(clientType)) {
                throw new TechnicalException("Only CAS, OAuth, OpenID and SAML protocols are supported: " + client);
            }
            try {
                credentials = client.getCredentials((WebContext)webContext);
                this.logger.debug("credentials: {}", (Object)credentials);
            }
            catch (RequiresHttpAction e) {
                this.logger.debug("requires http action: {}", (Throwable)e);
                response.flushBuffer();
                ExternalContext externalContext = ExternalContextHolder.getExternalContext();
                externalContext.recordResponseComplete();
                return new Event((Object)this, "stop");
            }
            Service service = (Service)session.getAttribute("service");
            context.getFlowScope().put("service", (Object)service);
            this.logger.debug("retrieve service: {}", (Object)service);
            if (service != null) {
                request.setAttribute("service", (Object)service.getId());
            }
            this.restoreRequestAttribute(request, session, "theme");
            this.restoreRequestAttribute(request, session, "locale");
            this.restoreRequestAttribute(request, session, "method");
            if (credentials != null) {
                DefaultAuthenticationContextBuilder builder = new DefaultAuthenticationContextBuilder(this.authenticationSystemSupport.getPrincipalElectionStrategy());
                AuthenticationTransaction transaction = AuthenticationTransaction.wrap((Credential[])new Credential[]{new ClientCredential(credentials)});
                this.authenticationSystemSupport.getAuthenticationTransactionManager().handle(transaction, (AuthenticationContextBuilder)builder);
                AuthenticationContext authenticationContext = builder.build(service);
                TicketGrantingTicket tgt = this.centralAuthenticationService.createTicketGrantingTicket(authenticationContext);
                WebUtils.putTicketGrantingTicketInScopes((RequestContext)context, (TicketGrantingTicket)tgt);
                return this.success();
            }
        }
        this.prepareForLoginPage(context);
        return this.error();
    }

    protected void prepareForLoginPage(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)context);
        HttpServletResponse response = WebUtils.getHttpServletResponse((RequestContext)context);
        HttpSession session = request.getSession();
        J2EContext webContext = new J2EContext(request, response);
        WebApplicationService service = WebUtils.getService((RequestContext)context);
        this.logger.debug("save service: {}", (Object)service);
        session.setAttribute("service", (Object)service);
        this.saveRequestParameter(request, session, "theme");
        this.saveRequestParameter(request, session, "locale");
        this.saveRequestParameter(request, session, "method");
        LinkedHashMap<String, String> urls = new LinkedHashMap<String, String>();
        for (Client client : this.clients.findAllClients()) {
            IndirectClient indirectClient = (IndirectClient)client;
            String name = client.getName().replace("Client", "");
            String redirectionUrl = indirectClient.getRedirectionUrl((WebContext)webContext);
            this.logger.debug("{} -> {}", (Object)name, (Object)redirectionUrl);
            urls.put(name, redirectionUrl);
        }
        context.getFlowScope().put(PAC4J_URLS, urls);
    }

    private void restoreRequestAttribute(HttpServletRequest request, HttpSession session, String name) {
        String value = (String)session.getAttribute(name);
        request.setAttribute(name, (Object)value);
    }

    private void saveRequestParameter(HttpServletRequest request, HttpSession session, String name) {
        String value = request.getParameter(name);
        if (value != null) {
            session.setAttribute(name, (Object)value);
        }
    }

    public Clients getClients() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        return (Clients)TraceLogAspect.aspectOf().traceMethod(new ClientAction$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void setClients(Clients clients) {
        this.clients = clients;
    }

    public CentralAuthenticationService getCentralAuthenticationService() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        return (CentralAuthenticationService)TraceLogAspect.aspectOf().traceMethod(new ClientAction$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    public AuthenticationSystemSupport getAuthenticationSystemSupport() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        return (AuthenticationSystemSupport)TraceLogAspect.aspectOf().traceMethod(new ClientAction$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    static final /* synthetic */ Clients getClients_aroundBody0(ClientAction ajc$this, JoinPoint joinPoint) {
        return ajc$this.clients;
    }

    static final /* synthetic */ CentralAuthenticationService getCentralAuthenticationService_aroundBody2(ClientAction ajc$this, JoinPoint joinPoint) {
        return ajc$this.centralAuthenticationService;
    }

    static final /* synthetic */ AuthenticationSystemSupport getAuthenticationSystemSupport_aroundBody4(ClientAction ajc$this, JoinPoint joinPoint) {
        return ajc$this.authenticationSystemSupport;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ClientAction.java", ClientAction.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClients", "org.jasig.cas.support.pac4j.web.flow.ClientAction", "", "", "", "org.pac4j.core.client.Clients"), 241);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getCentralAuthenticationService", "org.jasig.cas.support.pac4j.web.flow.ClientAction", "", "", "", "org.jasig.cas.CentralAuthenticationService"), 249);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAuthenticationSystemSupport", "org.jasig.cas.support.pac4j.web.flow.ClientAction", "", "", "", "org.jasig.cas.authentication.AuthenticationSystemSupport"), 257);
    }
}

