/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.radius.authentication.handler.support;

import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.jasig.cas.adaptors.radius.RadiusServer;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.principal.UsernamePasswordCredentials;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadiusAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    @NotNull
    @Size(min=1)
    private List<RadiusServer> servers;
    private boolean failoverOnException;
    private boolean failoverOnAuthenticationFailure;

    protected final boolean authenticateUsernamePasswordInternal(UsernamePasswordCredentials credentials) throws AuthenticationException {
        for (RadiusServer radiusServer : this.servers) {
            try {
                boolean response = radiusServer.authenticate(credentials);
                if (response || !response && !this.failoverOnAuthenticationFailure) {
                    return response;
                }
                this.log.debug("Failing over to next handler because failoverOnAuthenticationFailure is set to true.");
            }
            catch (Exception exception) {
                if (!this.failoverOnException) {
                    this.log.warn("Failover disabled.  Returning false for authentication request.");
                    continue;
                }
                this.log.warn("Failover enabled.  Trying next RadiusServer.");
            }
        }
        return false;
    }

    public void setFailoverOnAuthenticationFailure(boolean failoverOnAuthenticationFailure) {
        this.failoverOnAuthenticationFailure = failoverOnAuthenticationFailure;
    }

    public void setFailoverOnException(boolean failoverOnException) {
        this.failoverOnException = failoverOnException;
    }

    public void setServers(List<RadiusServer> servers) {
        this.servers = servers;
    }
}

