/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.radius;

import java.io.Serializable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import net.jradius.client.RadiusClient;
import net.jradius.dictionary.Attr_UserName;
import net.jradius.dictionary.Attr_UserPassword;
import net.jradius.exception.RadiusException;
import net.jradius.exception.UnknownAttributeException;
import net.jradius.packet.AccessAccept;
import net.jradius.packet.AccessRequest;
import net.jradius.packet.RadiusResponse;
import net.jradius.packet.attribute.AttributeFactory;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.packet.attribute.RadiusAttribute;
import org.jasig.cas.adaptors.radius.RadiusClientFactory;
import org.jasig.cas.adaptors.radius.RadiusProtocol;
import org.jasig.cas.adaptors.radius.RadiusServer;
import org.jasig.cas.authentication.PreventedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JRadiusServerImpl
implements RadiusServer {
    public static final int DEFAULT_RETRY_COUNT = 3;
    private static final Logger LOGGER = LoggerFactory.getLogger(JRadiusServerImpl.class);
    @NotNull
    private final RadiusProtocol protocol;
    @NotNull
    private final RadiusClientFactory radiusClientFactory;
    @Min(value=0L)
    private int retries = 3;

    public JRadiusServerImpl(RadiusProtocol protocol, RadiusClientFactory clientFactory) {
        this.protocol = protocol;
        this.radiusClientFactory = clientFactory;
    }

    @Override
    public boolean authenticate(String username, String password) throws PreventedException {
        AttributeList attributeList = new AttributeList();
        attributeList.add((RadiusAttribute)new Attr_UserName((Serializable)((Object)username)));
        attributeList.add((RadiusAttribute)new Attr_UserPassword((Serializable)((Object)password)));
        RadiusClient client = this.radiusClientFactory.newInstance();
        try {
            AccessRequest request = new AccessRequest(client, attributeList);
            RadiusResponse response = client.authenticate(request, RadiusClient.getAuthProtocol((String)this.protocol.getName()), this.retries);
            LOGGER.debug("RADIUS response from {}: {}", (Object)client.getRemoteInetAddress().getCanonicalHostName(), (Object)response.getClass().getName());
            if (response instanceof AccessAccept) {
                boolean bl = true;
                return bl;
            }
        }
        catch (UnknownAttributeException e) {
            throw new PreventedException((Throwable)e);
        }
        catch (RadiusException e) {
            throw new PreventedException((Throwable)e);
        }
        finally {
            client.close();
        }
        return false;
    }

    static {
        AttributeFactory.loadAttributeDictionary((String)"net.jradius.dictionary.AttributeDictionaryImpl");
    }
}

