/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.radius;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import net.jradius.client.RadiusClient;

public class RadiusClientFactory {
    @Min(value=1L)
    private int accountingPort = 1813;
    @Min(value=1L)
    private int authenticationPort = 1812;
    @Min(value=0L)
    private int socketTimeout = 60;
    @NotNull
    private InetAddress inetAddress;
    @NotNull
    private String sharedSecret;

    public void setAccountingPort(int port) {
        this.accountingPort = port;
    }

    public void setAuthenticationPort(int port) {
        this.authenticationPort = port;
    }

    public void setSocketTimeout(int timeout) {
        this.socketTimeout = timeout;
    }

    public void setInetAddress(String address) {
        try {
            this.inetAddress = InetAddress.getByName(address);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Invalid address " + address);
        }
    }

    public void setSharedSecret(String secret) {
        this.sharedSecret = secret;
    }

    public RadiusClient newInstance() {
        return new RadiusClient(this.inetAddress, this.sharedSecret, this.authenticationPort, this.accountingPort, this.socketTimeout);
    }
}

