/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.spnego.authentication.handler.support;

import java.util.regex.Pattern;
import jcifs.spnego.Authentication;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.handler.BadCredentialsAuthenticationException;
import org.jasig.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.SimplePrincipal;
import org.jasig.cas.support.spnego.authentication.principal.SpnegoCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JCIFSSpnegoAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Authentication authentication;
    private boolean principalWithDomainName = true;
    private boolean isNTLMallowed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doAuthentication(Credentials credentials) throws AuthenticationException {
        byte[] nextToken;
        java.security.Principal principal;
        SpnegoCredentials spnegoCredentials = (SpnegoCredentials)credentials;
        try {
            JCIFSSpnegoAuthenticationHandler jCIFSSpnegoAuthenticationHandler = this;
            synchronized (jCIFSSpnegoAuthenticationHandler) {
                this.authentication.reset();
                this.authentication.process(spnegoCredentials.getInitToken());
                principal = this.authentication.getPrincipal();
                nextToken = this.authentication.getNextToken();
            }
        }
        catch (jcifs.spnego.AuthenticationException e) {
            throw new BadCredentialsAuthenticationException((Throwable)e);
        }
        if (nextToken != null) {
            this.logger.debug("Setting nextToken in credentials");
            spnegoCredentials.setNextToken(nextToken);
        } else {
            this.logger.debug("nextToken is null");
        }
        if (principal != null) {
            if (spnegoCredentials.isNtlm()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("NTLM Credentials is valid for user [" + principal.getName() + "]");
                }
                spnegoCredentials.setPrincipal((Principal)this.getSimplePrincipal(principal.getName(), true));
                return this.isNTLMallowed;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Kerberos Credentials is valid for user [" + principal.getName() + "]");
            }
            spnegoCredentials.setPrincipal((Principal)this.getSimplePrincipal(principal.getName(), false));
            return true;
        }
        this.logger.debug("Principal is null, the processing of the SPNEGO Token failed");
        return false;
    }

    public boolean supports(Credentials credentials) {
        return credentials != null && SpnegoCredentials.class.equals(credentials.getClass());
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public void setPrincipalWithDomainName(boolean principalWithDomainName) {
        this.principalWithDomainName = principalWithDomainName;
    }

    public void setNTLMallowed(boolean isNTLMallowed) {
        this.isNTLMallowed = isNTLMallowed;
    }

    protected SimplePrincipal getSimplePrincipal(String name, boolean isNtlm) {
        if (this.principalWithDomainName) {
            return new SimplePrincipal(name);
        }
        if (isNtlm) {
            return Pattern.matches("\\S+\\\\\\S+", name) ? new SimplePrincipal(name.split("\\\\")[1]) : new SimplePrincipal(name);
        }
        return new SimplePrincipal(name.split("@")[0]);
    }
}

