/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.spnego.authentication.handler.support;

import java.net.URL;
import jcifs.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public final class JCIFSConfig
implements InitializingBean {
    private static final String DEFAULT_LOGIN_CONFIG = "/login.conf";
    private static final String SYS_PROP_USE_SUBJECT_CRED_ONLY = "javax.security.auth.useSubjectCredsOnly";
    private static final String SYS_PROP_LOGIN_CONF = "java.security.auth.login.config";
    private static final String SYS_PROP_KERBEROS_DEBUG = "sun.security.krb5.debug";
    private static final String SYS_PROP_KERBEROS_CONF = "java.security.krb5.conf";
    private static final String SYS_PROP_KERBEROS_REALM = "java.security.krb5.realm";
    private static final String SYS_PROP_KERBEROS_KDC = "java.security.krb5.kdc";
    private static final String JCIFS_PROP_DOMAIN_CONTROLLER = "jcifs.http.domainController";
    private static final String JCIFS_PROP_NETBIOS_WINS = "jcifs.netbios.wins";
    private static final String JCIFS_PROP_CLIENT_DOMAIN = "jcifs.smb.client.domain";
    private static final String JCIFS_PROP_CLIENT_USERNAME = "jcifs.smb.client.username";
    private static final String JCIFS_PROP_CLIENT_PASSWORD = "jcifs.smb.client.password";
    private static final String JCIFS_PROP_SERVICE_PRINCIPAL = "jcifs.spnego.servicePrincipal";
    private static final String JCIFS_PROP_SERVICE_PASSWORD = "jcifs.spnego.servicePassword";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String loginConf;

    public JCIFSConfig() {
        Config.setProperty((String)"jcifs.smb.client.soTimeout", (String)"300000");
        Config.setProperty((String)"jcifs.netbios.cachePolicy", (String)"600");
    }

    public void afterPropertiesSet() throws Exception {
        URL url;
        if (System.getProperty(SYS_PROP_LOGIN_CONF) != null) {
            this.logger.warn("found login config in system property, may overide : " + System.getProperty(SYS_PROP_LOGIN_CONF));
        }
        if ((url = this.getClass().getResource(this.loginConf == null ? DEFAULT_LOGIN_CONFIG : this.loginConf)) != null) {
            this.loginConf = url.toExternalForm();
        }
        if (this.loginConf != null) {
            System.setProperty(SYS_PROP_LOGIN_CONF, this.loginConf);
        } else {
            url = this.getClass().getResource("/jcifs/http/login.conf");
            if (url != null) {
                System.setProperty(SYS_PROP_LOGIN_CONF, url.toExternalForm());
            }
        }
        this.logger.debug("configured login configuration path : " + System.getProperty(SYS_PROP_LOGIN_CONF));
    }

    public void setJcifsServicePassword(String jcifsServicePassword) {
        this.logger.debug("jcifsServicePassword is set to *****");
        Config.setProperty((String)JCIFS_PROP_SERVICE_PASSWORD, (String)jcifsServicePassword);
    }

    public void setJcifsServicePrincipal(String jcifsServicePrincipal) {
        this.logger.debug("jcifsServicePrincipal is set to {}", (Object)jcifsServicePrincipal);
        Config.setProperty((String)JCIFS_PROP_SERVICE_PRINCIPAL, (String)jcifsServicePrincipal);
    }

    public void setKerberosConf(String kerberosConf) {
        this.logger.debug("kerberosConf is set to :{}", (Object)kerberosConf);
        System.setProperty(SYS_PROP_KERBEROS_CONF, kerberosConf);
    }

    public void setKerberosKdc(String kerberosKdc) {
        this.logger.debug("kerberosKdc is set to : {}", (Object)kerberosKdc);
        System.setProperty(SYS_PROP_KERBEROS_KDC, kerberosKdc);
    }

    public void setKerberosRealm(String kerberosRealm) {
        this.logger.debug("kerberosRealm is set to :{}", (Object)kerberosRealm);
        System.setProperty(SYS_PROP_KERBEROS_REALM, kerberosRealm);
    }

    public void setLoginConf(String loginConf) {
        this.loginConf = loginConf;
    }

    public void setUseSubjectCredsOnly(boolean useSubjectCredsOnly) {
        this.logger.debug("useSubjectCredsOnly is set to {}", (Object)useSubjectCredsOnly);
        System.setProperty(SYS_PROP_USE_SUBJECT_CRED_ONLY, Boolean.toString(useSubjectCredsOnly));
    }

    public void setKerberosDebug(String kerberosDebug) {
        this.logger.debug("kerberosDebug is set to : {}", (Object)kerberosDebug);
        System.setProperty(SYS_PROP_KERBEROS_DEBUG, kerberosDebug);
    }

    public void setJcifsDomain(String jcifsDomain) {
        this.logger.debug("jcifsDomain is set to {}", (Object)jcifsDomain);
        Config.setProperty((String)JCIFS_PROP_CLIENT_DOMAIN, (String)jcifsDomain);
    }

    public void setJcifsDomainController(String jcifsDomainController) {
        this.logger.debug("jcifsDomainController is set to {}", (Object)jcifsDomainController);
        Config.setProperty((String)JCIFS_PROP_DOMAIN_CONTROLLER, (String)jcifsDomainController);
    }

    public void setJcifsPassword(String jcifsPassword) {
        Config.setProperty((String)JCIFS_PROP_CLIENT_PASSWORD, (String)jcifsPassword);
        this.logger.debug("jcifsPassword is set to *****");
    }

    public void setJcifsUsername(String jcifsUsername) {
        this.logger.debug("jcifsUsername is set to {}", (Object)jcifsUsername);
        Config.setProperty((String)JCIFS_PROP_CLIENT_USERNAME, (String)jcifsUsername);
    }

    public void setJcifsNetbiosWins(String jcifsNetbiosWins) {
        this.logger.debug("jcifsNetbiosWins is set to {}", (Object)jcifsNetbiosWins);
        Config.setProperty((String)JCIFS_PROP_NETBIOS_WINS, (String)jcifsNetbiosWins);
    }
}

