/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.spnego.authentication.handler.support;

import java.security.GeneralSecurityException;
import javax.security.auth.login.FailedLoginException;
import javax.validation.constraints.NotNull;
import jcifs.Config;
import jcifs.UniAddress;
import jcifs.netbios.NbtAddress;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.ntlmssp.Type3Message;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbSession;
import org.jasig.cas.authentication.AuthenticationHandler;
import org.jasig.cas.authentication.BasicCredentialMetaData;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.CredentialMetaData;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.SimplePrincipal;
import org.jasig.cas.support.spnego.authentication.principal.SpnegoCredential;

public class NtlmAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    private boolean loadBalance = true;
    @NotNull
    private String domainController = Config.getProperty((String)"jcifs.smb.client.domain");
    private String includePattern = null;

    protected final HandlerResult doAuthentication(Credential credential) throws GeneralSecurityException, PreventedException {
        SpnegoCredential ntlmCredential = (SpnegoCredential)credential;
        byte[] src = ntlmCredential.getInitToken();
        UniAddress dc = null;
        boolean success = false;
        try {
            if (this.loadBalance) {
                if (this.includePattern != null) {
                    NbtAddress[] dcs;
                    for (NbtAddress dc2 : dcs = NbtAddress.getAllByName((String)this.domainController, (int)28, null, null)) {
                        if (!dc2.getHostAddress().matches(this.includePattern)) continue;
                        dc = new UniAddress((Object)dc2);
                        break;
                    }
                } else {
                    dc = new UniAddress((Object)NbtAddress.getByName((String)this.domainController, (int)28, null));
                }
            } else {
                dc = UniAddress.getByName((String)this.domainController, (boolean)true);
            }
            byte[] challenge = SmbSession.getChallenge((UniAddress)dc);
            switch (src[8]) {
                case 1: {
                    this.logger.debug("Type 1 received");
                    Type1Message type1 = new Type1Message(src);
                    Type2Message type2 = new Type2Message(type1, challenge, null);
                    this.logger.debug("Type 2 returned. Setting next token.");
                    ntlmCredential.setNextToken(type2.toByteArray());
                }
                case 3: {
                    this.logger.debug("Type 3 received");
                    Type3Message type3 = new Type3Message(src);
                    byte[] lmResponse = type3.getLMResponse() == null ? new byte[]{} : type3.getLMResponse();
                    byte[] ntResponse = type3.getNTResponse() == null ? new byte[]{} : type3.getNTResponse();
                    NtlmPasswordAuthentication ntlm = new NtlmPasswordAuthentication(type3.getDomain(), type3.getUser(), challenge, lmResponse, ntResponse);
                    this.logger.debug("Trying to authenticate {} with domain controller", (Object)type3.getUser());
                    try {
                        SmbSession.logon((UniAddress)dc, (NtlmPasswordAuthentication)ntlm);
                        ntlmCredential.setPrincipal((Principal)new SimplePrincipal(type3.getUser()));
                        success = true;
                        break;
                    }
                    catch (SmbAuthException sae) {
                        throw new FailedLoginException(sae.getMessage());
                    }
                }
            }
            this.logger.debug("Unknown type: {}", (Object)src[8]);
        }
        catch (Exception e) {
            throw new FailedLoginException(e.getMessage());
        }
        if (!success) {
            throw new FailedLoginException();
        }
        return new HandlerResult((AuthenticationHandler)this, (CredentialMetaData)new BasicCredentialMetaData((Credential)ntlmCredential), ntlmCredential.getPrincipal());
    }

    public boolean supports(Credential credential) {
        return credential instanceof SpnegoCredential;
    }

    public void setLoadBalance(boolean loadBalance) {
        this.loadBalance = loadBalance;
    }

    public void setDomainController(String domainController) {
        this.domainController = domainController;
    }

    public void setIncludePattern(String includePattern) {
        this.includePattern = includePattern;
    }
}

