/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.spnego.authentication.principal;

import java.io.Serializable;
import java.util.Arrays;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.support.spnego.util.SpnegoConstants;
import org.springframework.util.Assert;

public final class SpnegoCredential
implements Credential,
Serializable {
    private static final long serialVersionUID = 84084596791289548L;
    private final byte[] initToken;
    private byte[] nextToken;
    private Principal principal;
    private final boolean isNtlm;

    public SpnegoCredential(byte[] initToken) {
        Assert.notNull((Object)initToken, (String)"The initToken cannot be null.");
        this.initToken = initToken;
        this.isNtlm = this.isTokenNtlm(this.initToken);
    }

    public byte[] getInitToken() {
        return this.initToken;
    }

    public byte[] getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(byte[] nextToken) {
        this.nextToken = nextToken;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Principal principal) {
        this.principal = principal;
    }

    public boolean isNtlm() {
        return this.isNtlm;
    }

    public String getId() {
        return this.principal != null ? this.principal.getId() : "unknown";
    }

    public String toString() {
        return this.getId();
    }

    private boolean isTokenNtlm(byte[] token) {
        if (token == null || token.length < 8) {
            return false;
        }
        for (int i = 0; i < 8; ++i) {
            if (SpnegoConstants.NTLMSSP_SIGNATURE[i] == token[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        SpnegoCredential c = (SpnegoCredential)obj;
        return Arrays.equals(this.initToken, c.getInitToken()) && this.principal.equals(c.getPrincipal()) && Arrays.equals(this.nextToken, c.getNextToken());
    }

    public int hashCode() {
        return this.initToken.hashCode() ^ this.nextToken.hashCode() ^ this.principal.hashCode();
    }
}

