/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.handler.support;

import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.handler.PrincipalNameTransformer;
import org.jasig.cas.authentication.handler.support.TokenCredential;
import org.jasig.cas.integration.pac4j.authentication.handler.support.AbstractTokenWrapperAuthenticationHandler;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.RegisteredServiceProperty;
import org.jasig.cas.services.UnauthorizedServiceException;
import org.pac4j.http.credentials.authenticator.Authenticator;
import org.pac4j.jwt.credentials.authenticator.JwtAuthenticator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="tokenAuthenticationHandler")
public class TokenAuthenticationHandler
extends AbstractTokenWrapperAuthenticationHandler {
    protected HandlerResult postAuthenticate(Credential credential, HandlerResult result) {
        TokenCredential tokenCredential = (TokenCredential)credential;
        tokenCredential.setId(result.getPrincipal().getId());
        return super.postAuthenticate(credential, result);
    }

    protected Authenticator getAuthenticator(Credential credential) {
        TokenCredential tokenCredential = (TokenCredential)credential;
        this.logger.debug("Locating token secret for service [{}]", (Object)tokenCredential.getService());
        RegisteredService service = this.servicesManager.findServiceBy(tokenCredential.getService());
        String signingSecret = this.getRegisteredServiceJwtSigningSecret(service);
        String encryptionSecret = this.getRegisteredServiceJwtEncryptionSecret(service);
        if (StringUtils.isNotBlank((CharSequence)signingSecret)) {
            if (StringUtils.isBlank((CharSequence)encryptionSecret)) {
                this.logger.warn("JWT authentication is configured to share a single key for both signing/encryption");
                return new JwtAuthenticator(signingSecret);
            }
            return new JwtAuthenticator(signingSecret, encryptionSecret);
        }
        this.logger.warn("No token signing secret is defined for service [{}]. Ensure [{}] property is defined for service", (Object)service.getServiceId(), (Object)"jwtSigningSecret");
        return null;
    }

    @Autowired(required=false)
    public final void setPrincipalNameTransformer(@Qualifier(value="tokenPrincipalNameTransformer") PrincipalNameTransformer principalNameTransformer) {
        if (principalNameTransformer != null) {
            super.setPrincipalNameTransformer(principalNameTransformer);
        }
    }

    private String getRegisteredServiceJwtEncryptionSecret(RegisteredService service) {
        return this.getRegisteredServiceJwtSecret(service, "jwtEncryptionSecret");
    }

    private String getRegisteredServiceJwtSigningSecret(RegisteredService service) {
        return this.getRegisteredServiceJwtSecret(service, "jwtSigningSecret");
    }

    protected String getRegisteredServiceJwtSecret(RegisteredService service, String propName) {
        RegisteredServiceProperty propSigning;
        String tokenSigningSecret;
        if (service == null || !service.getAccessStrategy().isServiceAccessAllowed()) {
            this.logger.debug("Service is not defined/found or its access is disabled in the registry");
            throw new UnauthorizedServiceException("screen.service.error.message");
        }
        if (service.getProperties().containsKey(propName) && StringUtils.isNotBlank((CharSequence)(tokenSigningSecret = (propSigning = (RegisteredServiceProperty)service.getProperties().get(propName)).getValue()))) {
            this.logger.debug("Found the secret value {} for service [{}]", (Object)propName, (Object)service.getServiceId());
            return tokenSigningSecret;
        }
        this.logger.warn("Service [{}] does not define a property [{}] in the registry", (Object)service.getServiceId(), (Object)propName);
        return null;
    }
}

