/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow.token;

import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.AuthenticationContext;
import org.jasig.cas.authentication.AuthenticationContextBuilder;
import org.jasig.cas.authentication.AuthenticationSystemSupport;
import org.jasig.cas.authentication.AuthenticationTransaction;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.DefaultAuthenticationContextBuilder;
import org.jasig.cas.authentication.DefaultAuthenticationSystemSupport;
import org.jasig.cas.authentication.handler.support.TokenCredential;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

@Component(value="tokenAuthenticationAction")
public final class TokenAuthenticationAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenAuthenticationAction.class);
    @NotNull
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private CentralAuthenticationService centralAuthenticationService;
    @NotNull
    @Autowired(required=false)
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private AuthenticationSystemSupport authenticationSystemSupport = new DefaultAuthenticationSystemSupport();

    protected Event doExecute(RequestContext context) throws Exception {
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)context);
        String authTokenValue = request.getParameter("token");
        WebApplicationService service = WebUtils.getService((RequestContext)context);
        if (StringUtils.isNotBlank((CharSequence)authTokenValue) && service != null) {
            try {
                TokenCredential credential = new TokenCredential(authTokenValue, (Service)service);
                LOGGER.debug("Received token authentication request {} ", (Object)credential);
                DefaultAuthenticationContextBuilder builder = new DefaultAuthenticationContextBuilder(this.authenticationSystemSupport.getPrincipalElectionStrategy());
                AuthenticationTransaction transaction = AuthenticationTransaction.wrap((Credential[])new Credential[]{credential});
                this.authenticationSystemSupport.getAuthenticationTransactionManager().handle(transaction, (AuthenticationContextBuilder)builder);
                AuthenticationContext authenticationContext = builder.build((Service)service);
                TicketGrantingTicket tgt = this.centralAuthenticationService.createTicketGrantingTicket(authenticationContext);
                WebUtils.putTicketGrantingTicketInScopes((RequestContext)context, (TicketGrantingTicket)tgt);
                return this.success();
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        return this.error();
    }

    public void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }
}

