/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.x509.authentication.principal;

import edu.vt.middleware.crypt.x509.DNUtils;
import edu.vt.middleware.crypt.x509.types.AttributeType;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import javax.validation.constraints.NotNull;
import org.jasig.cas.adaptors.x509.authentication.principal.AbstractX509CertificateCredentialsToPrincipalResolver;

public class X509CertificateCredentialsToSubjectPrinciplalResolver
extends AbstractX509CertificateCredentialsToPrincipalResolver {
    private static final Pattern ATTR_PATTERN = Pattern.compile("\\$(\\w+)");
    @NotNull
    private String descriptor;

    public void setDescriptor(String s) {
        this.descriptor = s;
    }

    protected String resolvePrincipalInternal(X509Certificate certificate) {
        this.log.debug("Resolving principal for " + certificate);
        StringBuffer sb = new StringBuffer();
        Matcher m = ATTR_PATTERN.matcher(this.descriptor);
        HashMap<String, AttributeContext> attrMap = new HashMap<String, AttributeContext>();
        while (m.find()) {
            String name = m.group(1);
            if (!attrMap.containsKey(name)) {
                String[] values = DNUtils.getAttributeValues((X500Principal)certificate.getSubjectX500Principal(), (AttributeType)AttributeType.fromName((String)name));
                attrMap.put(name, new AttributeContext(name, values));
            }
            AttributeContext context = (AttributeContext)attrMap.get(name);
            m.appendReplacement(sb, context.nextValue());
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static final class AttributeContext {
        private int currentIndex;
        private String name;
        private String[] values;

        public AttributeContext(String name, String[] values) {
            this.values = values;
        }

        public String nextValue() {
            if (this.currentIndex == this.values.length) {
                throw new IllegalStateException("No values remaining for attribute " + this.name);
            }
            return this.values[this.currentIndex++];
        }
    }
}

