/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.x509.authentication.handler.support;

import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.adaptors.x509.authentication.handler.support.AbstractCRLRevocationChecker;
import org.jasig.cas.adaptors.x509.util.CertUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class ResourceCRLRevocationChecker
extends AbstractCRLRevocationChecker
implements InitializingBean {
    public static final int DEFAULT_REFRESH_INTERVAL = 3600;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private int refreshInterval = 3600;
    private CRLFetcher fetcher;
    private final Map<X500Principal, X509CRL> crlIssuerMap = Collections.synchronizedMap(new HashMap());

    public ResourceCRLRevocationChecker(Resource crl) {
        this(new Resource[]{crl});
    }

    public ResourceCRLRevocationChecker(Resource[] crls) {
        this.fetcher = new CRLFetcher(crls);
    }

    public void setRefreshInterval(int seconds) {
        if (seconds <= 0) {
            throw new IllegalArgumentException("Refresh interval must be positive integer.");
        }
        this.refreshInterval = seconds;
    }

    public void afterPropertiesSet() throws Exception {
        this.fetcher.fetch(true);
        Runnable scheduledFetcher = new Runnable(){

            @Override
            public void run() {
                ResourceCRLRevocationChecker.this.getFetcher().fetch(false);
            }
        };
        this.scheduler.scheduleAtFixedRate(scheduledFetcher, this.refreshInterval, this.refreshInterval, TimeUnit.SECONDS);
    }

    protected CRLFetcher getFetcher() {
        return this.fetcher;
    }

    protected void addCrl(X509CRL crl) {
        X500Principal issuer = crl.getIssuerX500Principal();
        this.log.debug((Object)("Adding CRL for issuer " + issuer));
        this.crlIssuerMap.put(issuer, crl);
    }

    @Override
    protected X509CRL getCRL(X509Certificate cert) {
        return this.crlIssuerMap.get(cert.getIssuerX500Principal());
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.scheduler.shutdown();
    }

    protected class CRLFetcher {
        private final Log logger = LogFactory.getLog(this.getClass());
        private List<Resource> resources;

        public CRLFetcher(Resource[] crls) {
            if (crls == null) {
                throw new IllegalArgumentException("CRL resources cannot be null.");
            }
            this.resources = new ArrayList<Resource>();
            Resource[] resourceArray = crls;
            int n = crls.length;
            int n2 = 0;
            while (n2 < n) {
                Resource r = resourceArray[n2];
                if (r != null) {
                    this.resources.add(r);
                }
                ++n2;
            }
            if (this.resources.size() == 0) {
                throw new IllegalArgumentException("Must provide at least one non-null CRL resource.");
            }
        }

        public void fetch(boolean throwOnError) {
            for (Resource r : this.resources) {
                this.logger.debug((Object)("Fetching CRL data from " + r));
                try {
                    ResourceCRLRevocationChecker.this.addCrl(CertUtils.fetchCRL(r));
                }
                catch (Exception e) {
                    if (!throwOnError) continue;
                    throw new RuntimeException("Error fetching CRL from " + r, e);
                }
            }
        }
    }
}

