/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.x509.authentication.handler.support;

import java.security.GeneralSecurityException;
import java.security.cert.X509CRL;
import java.util.Calendar;
import javax.validation.constraints.Min;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.adaptors.x509.authentication.handler.support.ExpiredCRLException;
import org.jasig.cas.adaptors.x509.authentication.handler.support.RevocationPolicy;
import org.jasig.cas.adaptors.x509.util.CertUtils;

public final class ThresholdExpiredCRLRevocationPolicy
implements RevocationPolicy<X509CRL> {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final int DEFAULT_THRESHOLD = 172800;
    @Min(value=0L)
    private int threshold = 172800;

    @Override
    public void apply(X509CRL crl) throws GeneralSecurityException {
        Calendar cutoff = Calendar.getInstance();
        if (CertUtils.isExpired(crl, cutoff.getTime())) {
            cutoff.add(13, -this.threshold);
            if (CertUtils.isExpired(crl, cutoff.getTime())) {
                throw new ExpiredCRLException(crl.toString(), cutoff.getTime(), this.threshold);
            }
            this.log.info((Object)String.format("CRL expired on %s but is within threshold period, %s seconds.", crl.getNextUpdate(), this.threshold));
        }
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }
}

