/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.support;

import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import org.jasig.cas.web.support.AbstractThrottledSubmissionHandlerInterceptorAdapter;

public abstract class AbstractInMemoryThrottledSubmissionHandlerInterceptorAdapter
extends AbstractThrottledSubmissionHandlerInterceptorAdapter {
    private final ConcurrentMap<String, Date> ipMap = new ConcurrentHashMap<String, Date>();

    @Override
    protected final boolean exceedsThreshold(HttpServletRequest request) {
        Date last = (Date)this.ipMap.get(this.constructKey(request));
        if (last == null) {
            return false;
        }
        return this.submissionRate(new Date(), last) > this.getThresholdRate();
    }

    @Override
    protected final void recordSubmissionFailure(HttpServletRequest request) {
        this.ipMap.put(this.constructKey(request), new Date());
    }

    protected abstract String constructKey(HttpServletRequest var1);

    public final void decrementCounts() {
        Set keys = this.ipMap.keySet();
        this.logger.debug("Decrementing counts for throttler.  Starting key count: {}", (Object)keys.size());
        Date now = new Date();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!(this.submissionRate(now, (Date)this.ipMap.get(key)) < this.getThresholdRate())) continue;
            this.logger.trace("Removing entry for key {}", (Object)key);
            iter.remove();
        }
        this.logger.debug("Done decrementing count for throttler.");
    }

    private double submissionRate(Date a, Date b) {
        return 1000.0 / (double)(a.getTime() - b.getTime());
    }
}

