/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.support;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.util.CookieGenerator;
import org.springframework.web.util.WebUtils;

public class CookieRetrievingCookieGenerator
extends CookieGenerator {
    private int rememberMeMaxAge = 7889231;

    public void addCookie(HttpServletRequest request, HttpServletResponse response, String cookieValue) {
        if (!StringUtils.hasText((String)request.getParameter("rememberMe"))) {
            super.addCookie(response, cookieValue);
        } else {
            Cookie cookie = this.createCookie(cookieValue);
            cookie.setMaxAge(this.rememberMeMaxAge);
            if (this.isCookieSecure()) {
                cookie.setSecure(true);
            }
            response.addCookie(cookie);
        }
    }

    public void removeCookie(HttpServletResponse response) {
        Cookie cookie = this.createCookie("");
        cookie.setMaxAge(0);
        super.addCookie(response, "");
    }

    public String retrieveCookieValue(HttpServletRequest request) {
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)request, (String)this.getCookieName());
        return cookie == null ? null : cookie.getValue();
    }

    public void setRememberMeMaxAge(int maxAge) {
        this.rememberMeMaxAge = maxAge;
    }
}

