/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services.web;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.services.web.ServiceThemeResolver$AjcClosure1;
import org.jasig.cas.web.support.WebUtils;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.web.servlet.theme.AbstractThemeResolver;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public final class ServiceThemeResolver
extends AbstractThemeResolver {
    private static final Logger LOGGER;
    private ServicesManager servicesManager;
    private Map<Pattern, String> overrides = new HashMap<Pattern, String>();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public String resolveThemeName(HttpServletRequest request) {
        HttpServletRequest httpServletRequest = request;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)httpServletRequest);
        Object[] objectArray = new Object[]{this, httpServletRequest, joinPoint};
        return (String)TraceLogAspect.aspectOf().traceMethod(new ServiceThemeResolver$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void setThemeName(HttpServletRequest request, HttpServletResponse response, String themeName) {
    }

    public void setServicesManager(ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }

    public void setMobileBrowsers(Map<String, String> mobileOverrides) {
        this.overrides = new HashMap<Pattern, String>();
        for (Map.Entry<String, String> entry : mobileOverrides.entrySet()) {
            this.overrides.put(Pattern.compile(entry.getKey()), entry.getValue());
        }
    }

    static {
        ServiceThemeResolver.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(ServiceThemeResolver.class);
    }

    static final /* synthetic */ String resolveThemeName_aroundBody0(ServiceThemeResolver ajc$this, HttpServletRequest request, JoinPoint joinPoint) {
        RegisteredService rService;
        RequestContext context;
        WebApplicationService service;
        if (ajc$this.servicesManager == null) {
            return ajc$this.getDefaultThemeName();
        }
        String userAgent = request.getHeader("User-Agent");
        if (StringUtils.isBlank((CharSequence)userAgent)) {
            return ajc$this.getDefaultThemeName();
        }
        for (Map.Entry<Pattern, String> entry : ajc$this.overrides.entrySet()) {
            if (!entry.getKey().matcher(userAgent).matches()) continue;
            request.setAttribute("isMobile", (Object)"true");
            request.setAttribute("browserType", (Object)entry.getValue());
            break;
        }
        if ((service = WebUtils.getService((RequestContext)(context = RequestContextHolder.getRequestContext()))) != null && (rService = ajc$this.servicesManager.findServiceBy((Service)service)) != null && rService.getAccessStrategy().isServiceAccessAllowed() && StringUtils.isNotBlank((CharSequence)rService.getTheme())) {
            LOGGER.debug("Service [{}] is configured to use a custom theme [{}]", (Object)rService, (Object)rService.getTheme());
            CasThemeResourceBundleMessageSource messageSource = new CasThemeResourceBundleMessageSource();
            messageSource.setBasename(rService.getTheme());
            if (messageSource.doGetBundle(rService.getTheme(), request.getLocale()) != null) {
                LOGGER.debug("Found custom theme [{}] for service [{}]", (Object)rService.getTheme(), (Object)rService);
                return rService.getTheme();
            }
            LOGGER.warn("Custom theme {} for service {} cannot be located. Falling back to default theme...", (Object)rService.getTheme(), (Object)rService);
        }
        return ajc$this.getDefaultThemeName();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ServiceThemeResolver.java", ServiceThemeResolver.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "resolveThemeName", "org.jasig.cas.services.web.ServiceThemeResolver", "javax.servlet.http.HttpServletRequest", "request", "", "java.lang.String"), 62);
    }

    private static class CasThemeResourceBundleMessageSource
    extends ResourceBundleMessageSource {
        private CasThemeResourceBundleMessageSource() {
        }

        protected ResourceBundle doGetBundle(String basename, Locale locale) {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(basename, locale, this.getBundleClassLoader());
                if (bundle != null && bundle.keySet().size() > 0) {
                    return bundle;
                }
            }
            catch (Exception e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }
}

