/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.MessageDescriptor;
import org.jasig.cas.authentication.AuthenticationException;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.TicketCreationException;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.web.flow.AuthenticationViaFormAction$AjcClosure1;
import org.jasig.cas.web.support.WebUtils;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class AuthenticationViaFormAction {
    public static final String SUCCESS = "success";
    public static final String SUCCESS_WITH_WARNINGS = "successWithWarnings";
    public static final String WARN = "warn";
    public static final String AUTHENTICATION_FAILURE = "authenticationFailure";
    public static final String ERROR = "error";
    public static final String PUBLIC_WORKSTATION_ATTRIBUTE = "publicWorkstation";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private CentralAuthenticationService centralAuthenticationService;
    @NotNull
    private CookieGenerator warnCookieGenerator;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public final Event submit(RequestContext context, Credential credential, MessageContext messageContext) {
        RequestContext requestContext = context;
        Credential credential2 = credential;
        MessageContext messageContext2 = messageContext;
        Object[] objectArray = new Object[]{requestContext, credential2, messageContext2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, requestContext, credential2, messageContext2, joinPoint};
        return (Event)TraceLogAspect.aspectOf().traceMethod(new AuthenticationViaFormAction$AjcClosure1(objectArray2).linkClosureAndJoinPoint(69648));
    }

    protected boolean checkLoginTicketIfExists(RequestContext context) {
        String loginTicketFromFlowScope = WebUtils.getLoginTicketFromFlowScope((RequestContext)context);
        String loginTicketFromRequest = WebUtils.getLoginTicketFromRequest((RequestContext)context);
        this.logger.trace("Comparing login ticket in the flow scope [{}] with login ticket in the request [{}]", (Object)loginTicketFromFlowScope, (Object)loginTicketFromRequest);
        return StringUtils.equals((CharSequence)loginTicketFromFlowScope, (CharSequence)loginTicketFromRequest);
    }

    protected Event returnInvalidLoginTicketEvent(RequestContext context, MessageContext messageContext) {
        String loginTicketFromRequest = WebUtils.getLoginTicketFromRequest((RequestContext)context);
        this.logger.warn("Invalid login ticket [{}]", (Object)loginTicketFromRequest);
        messageContext.addMessage(new MessageBuilder().error().code("error.invalid.loginticket").build());
        return this.newEvent(ERROR);
    }

    protected boolean isRequestAskingForServiceTicket(RequestContext context) {
        String ticketGrantingTicketId = WebUtils.getTicketGrantingTicketId((RequestContext)context);
        WebApplicationService service = WebUtils.getService((RequestContext)context);
        return StringUtils.isNotBlank((CharSequence)context.getRequestParameters().get("renew")) && ticketGrantingTicketId != null && service != null;
    }

    protected Event grantServiceTicket(RequestContext context, Credential credential) {
        String ticketGrantingTicketId = WebUtils.getTicketGrantingTicketId((RequestContext)context);
        try {
            WebApplicationService service = WebUtils.getService((RequestContext)context);
            ServiceTicket serviceTicketId = this.centralAuthenticationService.grantServiceTicket(ticketGrantingTicketId, (Service)service, new Credential[]{credential});
            WebUtils.putServiceTicketInRequestScope((RequestContext)context, (ServiceTicket)serviceTicketId);
            this.putWarnCookieIfRequestParameterPresent(context);
            return this.newEvent(WARN);
        }
        catch (AuthenticationException e) {
            return this.newEvent(AUTHENTICATION_FAILURE, (Exception)((Object)e));
        }
        catch (TicketCreationException e) {
            this.logger.warn("Invalid attempt to access service using renew=true with different credential. Ending SSO session.");
            this.centralAuthenticationService.destroyTicketGrantingTicket(ticketGrantingTicketId);
        }
        catch (TicketException e) {
            return this.newEvent(ERROR, (Exception)((Object)e));
        }
        return this.newEvent(ERROR);
    }

    protected Event createTicketGrantingTicket(RequestContext context, Credential credential, MessageContext messageContext) {
        try {
            TicketGrantingTicket tgt = this.centralAuthenticationService.createTicketGrantingTicket(new Credential[]{credential});
            WebUtils.putTicketGrantingTicketInScopes((RequestContext)context, (TicketGrantingTicket)tgt);
            this.putWarnCookieIfRequestParameterPresent(context);
            this.putPublicWorkstationToFlowIfRequestParameterPresent(context);
            if (this.addWarningMessagesToMessageContextIfNeeded(tgt, messageContext)) {
                return this.newEvent(SUCCESS_WITH_WARNINGS);
            }
            return this.newEvent(SUCCESS);
        }
        catch (AuthenticationException e) {
            this.logger.debug(e.getMessage(), (Throwable)e);
            return this.newEvent(AUTHENTICATION_FAILURE, (Exception)((Object)e));
        }
        catch (Exception e) {
            this.logger.debug(e.getMessage(), (Throwable)e);
            return this.newEvent(ERROR, e);
        }
    }

    protected boolean addWarningMessagesToMessageContextIfNeeded(TicketGrantingTicket tgtId, MessageContext messageContext) {
        boolean foundAndAddedWarnings = false;
        for (Map.Entry entry : tgtId.getAuthentication().getSuccesses().entrySet()) {
            for (MessageDescriptor message : ((HandlerResult)entry.getValue()).getWarnings()) {
                this.addWarningToContext(messageContext, message);
                foundAndAddedWarnings = true;
            }
        }
        return foundAndAddedWarnings;
    }

    private void putWarnCookieIfRequestParameterPresent(RequestContext context) {
        HttpServletResponse response = WebUtils.getHttpServletResponse((RequestContext)context);
        if (StringUtils.isNotBlank((CharSequence)context.getExternalContext().getRequestParameterMap().get(WARN))) {
            this.warnCookieGenerator.addCookie(response, "true");
        } else {
            this.warnCookieGenerator.removeCookie(response);
        }
    }

    private void putPublicWorkstationToFlowIfRequestParameterPresent(RequestContext context) {
        if (StringUtils.isNotBlank((CharSequence)context.getExternalContext().getRequestParameterMap().get(PUBLIC_WORKSTATION_ATTRIBUTE))) {
            context.getFlowScope().put(PUBLIC_WORKSTATION_ATTRIBUTE, (Object)Boolean.TRUE);
        }
    }

    private Event newEvent(String id) {
        return new Event((Object)this, id);
    }

    private Event newEvent(String id, Exception error) {
        return new Event((Object)this, id, (AttributeMap)new LocalAttributeMap(ERROR, (Object)error));
    }

    public final void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    public final void setWarnCookieGenerator(CookieGenerator warnCookieGenerator) {
        this.warnCookieGenerator = warnCookieGenerator;
    }

    @Deprecated
    public void setTicketRegistry(TicketRegistry ticketRegistry) {
        this.logger.warn("setTicketRegistry() has no effect and will be removed in future CAS versions.");
    }

    private void addWarningToContext(MessageContext context, MessageDescriptor warning) {
        MessageBuilder builder = new MessageBuilder().warning().code(warning.getCode()).defaultText(warning.getDefaultMessage()).args((Object[])warning.getParams());
        context.addMessage(builder.build());
    }

    static {
        AuthenticationViaFormAction.ajc$preClinit();
    }

    static final /* synthetic */ Event submit_aroundBody0(AuthenticationViaFormAction ajc$this, RequestContext context, Credential credential, MessageContext messageContext, JoinPoint joinPoint) {
        if (!ajc$this.checkLoginTicketIfExists(context)) {
            return ajc$this.returnInvalidLoginTicketEvent(context, messageContext);
        }
        if (ajc$this.isRequestAskingForServiceTicket(context)) {
            return ajc$this.grantServiceTicket(context, credential);
        }
        return ajc$this.createTicketGrantingTicket(context, credential, messageContext);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AuthenticationViaFormAction.java", AuthenticationViaFormAction.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "submit", "org.jasig.cas.web.flow.AuthenticationViaFormAction", "org.springframework.webflow.execution.RequestContext:org.jasig.cas.authentication.Credential:org.springframework.binding.message.MessageContext", "context:credential:messageContext", "", "org.springframework.webflow.execution.Event"), 98);
    }
}

