/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.report;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.jasig.cas.monitor.HealthCheckMonitor;
import org.jasig.cas.monitor.HealthStatus;
import org.jasig.cas.monitor.Status;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller(value="healthCheckController")
@RequestMapping(value={"/status"})
public class HealthCheckController {
    private static final String HEADER_PREFIX = "X-CAS-";
    @NotNull
    @Autowired
    private HealthCheckMonitor healthCheckMonitor;

    @RequestMapping(method={RequestMethod.GET})
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HealthStatus healthStatus = this.healthCheckMonitor.observe();
        StringBuilder sb = new StringBuilder();
        sb.append("Health: ").append(healthStatus.getCode());
        int i = 0;
        for (Map.Entry entry : healthStatus.getDetails().entrySet()) {
            String name = (String)entry.getKey();
            Status status = (Status)entry.getValue();
            response.addHeader(HEADER_PREFIX + name, String.format("%s;%s", status.getCode(), status.getDescription()));
            sb.append("\n\n\t").append(++i).append('.').append(name).append(": ");
            sb.append(status.getCode());
            if (status.getDescription() == null) continue;
            sb.append(" - ").append(status.getDescription());
        }
        response.setStatus(healthStatus.getCode().value());
        response.setContentType("text/plain");
        response.getOutputStream().write(sb.toString().getBytes(response.getCharacterEncoding()));
        return null;
    }
}

