/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.report;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.Predicate;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.web.report.SingleSignOnSessionsReportController$1$AjcClosure1;
import org.jasig.cas.web.report.SingleSignOnSessionsReportController$AjcClosure1;
import org.jasig.cas.web.report.SingleSignOnSessionsReportController$SsoSessionAttributeKeys$AjcClosure1;
import org.jasig.cas.web.report.SingleSignOnSessionsReportController$SsoSessionAttributeKeys$AjcClosure3;
import org.jasig.cas.web.report.SingleSignOnSessionsReportController$SsoSessionAttributeKeys$AjcClosure5;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller(value="singleSignOnSessionsReportController")
@RequestMapping(value={"/statistics/ssosessions"})
public final class SingleSignOnSessionsReportController {
    private static final String VIEW_SSO_SESSIONS = "monitoring/viewSsoSessions";
    private static final String ROOT_REPORT_ACTIVE_SESSIONS_KEY = "activeSsoSessions";
    private static final String ROOT_REPORT_NA_KEY = "notAvailable";
    private static final Logger LOGGER;
    private final ObjectMapper jsonMapper = new ObjectMapper();
    @Autowired
    private CentralAuthenticationService centralAuthenticationService;
    @Value(value="${sso.sessions.include.tgt:false}")
    private boolean includeTicketGrantingTicketId;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public SingleSignOnSessionsReportController() {
        this.jsonMapper.disable(SerializationFeature.INDENT_OUTPUT);
        this.jsonMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }

    private Collection<Map<String, Object>> getSsoSessions() {
        ArrayList activeSessions = new ArrayList();
        for (Ticket ticket : this.getNonExpiredTicketGrantingTickets()) {
            TicketGrantingTicket tgt = (TicketGrantingTicket)ticket;
            HashMap<String, Object> sso = new HashMap<String, Object>(SsoSessionAttributeKeys.values().length);
            sso.put(SsoSessionAttributeKeys.AUTHENTICATED_PRINCIPAL.toString(), tgt.getAuthentication().getPrincipal().getId());
            sso.put(SsoSessionAttributeKeys.AUTHENTICATION_DATE.toString(), tgt.getAuthentication().getAuthenticationDate());
            sso.put(SsoSessionAttributeKeys.NUMBER_OF_USES.toString(), tgt.getCountOfUses());
            if (this.includeTicketGrantingTicketId) {
                sso.put(SsoSessionAttributeKeys.TICKET_GRANTING_TICKET.toString(), tgt.getId());
            }
            activeSessions.add(Collections.unmodifiableMap(sso));
        }
        return Collections.unmodifiableCollection(activeSessions);
    }

    private Collection<Ticket> getNonExpiredTicketGrantingTickets() {
        return this.centralAuthenticationService.getTickets(new Predicate(){
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

            public boolean evaluate(Object ticket) {
                Object object = ticket;
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)object);
                Object[] objectArray = new Object[]{this, object, joinPoint};
                return Conversions.booleanValue((Object)TraceLogAspect.aspectOf().traceMethod(new SingleSignOnSessionsReportController$1$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648)));
            }

            static {
                1.ajc$preClinit();
            }

            static final /* synthetic */ boolean evaluate_aroundBody0(1 ajc$this, Object ticket, JoinPoint joinPoint) {
                if (ticket instanceof TicketGrantingTicket) {
                    return !((TicketGrantingTicket)ticket).isExpired();
                }
                return false;
            }

            private static /* synthetic */ void ajc$preClinit() {
                Factory factory = new Factory("SingleSignOnSessionsReportController.java", 1.class);
                ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "evaluate", "org.jasig.cas.web.report.SingleSignOnSessionsReportController$1", "java.lang.Object", "ticket", "", "boolean"), 138);
            }
        });
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView showSsoSessions() throws Exception {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (ModelAndView)TraceLogAspect.aspectOf().traceMethod(new SingleSignOnSessionsReportController$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    static {
        SingleSignOnSessionsReportController.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(SingleSignOnSessionsReportController.class);
    }

    static final /* synthetic */ ModelAndView showSsoSessions_aroundBody0(SingleSignOnSessionsReportController ajc$this, JoinPoint joinPoint) {
        HashMap<String, Collection<Map<String, Object>>> sessionsMap = new HashMap<String, Collection<Map<String, Object>>>(1);
        sessionsMap.put(ROOT_REPORT_ACTIVE_SESSIONS_KEY, ajc$this.getSsoSessions());
        String jsonRepresentation = ajc$this.jsonMapper.writeValueAsString(sessionsMap);
        ModelAndView modelAndView = new ModelAndView(VIEW_SSO_SESSIONS);
        modelAndView.addObject(ROOT_REPORT_ACTIVE_SESSIONS_KEY, (Object)jsonRepresentation);
        return modelAndView;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SingleSignOnSessionsReportController.java", SingleSignOnSessionsReportController.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "showSsoSessions", "org.jasig.cas.web.report.SingleSignOnSessionsReportController", "", "", "java.lang.Exception", "org.springframework.web.servlet.ModelAndView"), 154);
    }

    private static final class SsoSessionAttributeKeys
    extends Enum<SsoSessionAttributeKeys> {
        public static final /* enum */ SsoSessionAttributeKeys AUTHENTICATED_PRINCIPAL;
        public static final /* enum */ SsoSessionAttributeKeys AUTHENTICATION_DATE;
        public static final /* enum */ SsoSessionAttributeKeys TICKET_GRANTING_TICKET;
        public static final /* enum */ SsoSessionAttributeKeys NUMBER_OF_USES;
        private String attributeKey;
        private static final /* synthetic */ SsoSessionAttributeKeys[] $VALUES;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        public static SsoSessionAttributeKeys[] values() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
            Object[] objectArray = new Object[]{joinPoint};
            return (SsoSessionAttributeKeys[])TraceLogAspect.aspectOf().traceMethod(new SingleSignOnSessionsReportController$SsoSessionAttributeKeys$AjcClosure1(objectArray).linkClosureAndJoinPoint(65536));
        }

        public static SsoSessionAttributeKeys valueOf(String name) {
            String string = name;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)string);
            Object[] objectArray = new Object[]{string, joinPoint};
            return (SsoSessionAttributeKeys)((Object)TraceLogAspect.aspectOf().traceMethod(new SingleSignOnSessionsReportController$SsoSessionAttributeKeys$AjcClosure3(objectArray).linkClosureAndJoinPoint(65536)));
        }

        private SsoSessionAttributeKeys(String attributeKey) {
            this.attributeKey = attributeKey;
        }

        public String toString() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this));
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)TraceLogAspect.aspectOf().traceMethod(new SingleSignOnSessionsReportController$SsoSessionAttributeKeys$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
        }

        static {
            SsoSessionAttributeKeys.ajc$preClinit();
            AUTHENTICATED_PRINCIPAL = new SsoSessionAttributeKeys("authenticated_principal");
            AUTHENTICATION_DATE = new SsoSessionAttributeKeys("authentication_date");
            TICKET_GRANTING_TICKET = new SsoSessionAttributeKeys("ticket_granting_ticket");
            NUMBER_OF_USES = new SsoSessionAttributeKeys("number_of_uses");
            $VALUES = new SsoSessionAttributeKeys[]{AUTHENTICATED_PRINCIPAL, AUTHENTICATION_DATE, TICKET_GRANTING_TICKET, NUMBER_OF_USES};
        }

        static final /* synthetic */ SsoSessionAttributeKeys[] values_aroundBody0(JoinPoint joinPoint) {
            return (SsoSessionAttributeKeys[])$VALUES.clone();
        }

        static final /* synthetic */ SsoSessionAttributeKeys valueOf_aroundBody2(String name, JoinPoint joinPoint) {
            return Enum.valueOf(SsoSessionAttributeKeys.class, name);
        }

        static final /* synthetic */ String toString_aroundBody4(SsoSessionAttributeKeys ajc$this, JoinPoint joinPoint) {
            return ajc$this.attributeKey;
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("SingleSignOnSessionsReportController.java", SsoSessionAttributeKeys.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "values", "org.jasig.cas.web.report.SingleSignOnSessionsReportController$SsoSessionAttributeKeys", "", "", "", "[Lorg.jasig.cas.web.report.SingleSignOnSessionsReportController$SsoSessionAttributeKeys;"), 60);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "valueOf", "org.jasig.cas.web.report.SingleSignOnSessionsReportController$SsoSessionAttributeKeys", "java.lang.String", "name", "", "org.jasig.cas.web.report.SingleSignOnSessionsReportController$SsoSessionAttributeKeys"), 60);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toString", "org.jasig.cas.web.report.SingleSignOnSessionsReportController$SsoSessionAttributeKeys", "", "", "", "java.lang.String"), 79);
        }
    }
}

