/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.support;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.web.support.AbstractThrottledSubmissionHandlerInterceptorAdapter;
import org.jasig.cas.web.support.InspektrThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter$1$AjcClosure1;
import org.jasig.cas.web.support.InspektrThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter$2$AjcClosure1;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.jasig.inspektr.audit.AuditActionContext;
import org.jasig.inspektr.audit.AuditPointRuntimeInfo;
import org.jasig.inspektr.audit.AuditTrailManager;
import org.jasig.inspektr.common.web.ClientInfo;
import org.jasig.inspektr.common.web.ClientInfoHolder;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class InspektrThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter
extends AbstractThrottledSubmissionHandlerInterceptorAdapter {
    private static final String DEFAULT_APPLICATION_CODE = "CAS";
    private static final String DEFAULT_AUTHN_FAILED_ACTION = "AUTHENTICATION_FAILED";
    private static final String INSPEKTR_ACTION = "THROTTLED_LOGIN_ATTEMPT";
    private static final double NUMBER_OF_MILLISECONDS_IN_SECOND = 1000.0;
    private final AuditTrailManager auditTrailManager;
    private final JdbcTemplate jdbcTemplate;
    private String applicationCode = "CAS";
    private String authenticationFailureCode = "AUTHENTICATION_FAILED";

    public InspektrThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter(AuditTrailManager auditTrailManager, DataSource dataSource) {
        this.auditTrailManager = auditTrailManager;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    @Override
    protected boolean exceedsThreshold(HttpServletRequest request) {
        String query = "SELECT AUD_DATE FROM COM_AUDIT_TRAIL WHERE AUD_CLIENT_IP = ? AND AUD_USER = ? AND AUD_ACTION = ? AND APPLIC_CD = ? AND AUD_DATE >= ? ORDER BY AUD_DATE DESC";
        String userToUse = this.constructUsername(request, this.getUsernameParameter());
        Calendar cutoff = Calendar.getInstance();
        cutoff.add(13, -1 * this.getFailureRangeInSeconds());
        List failures = this.jdbcTemplate.query("SELECT AUD_DATE FROM COM_AUDIT_TRAIL WHERE AUD_CLIENT_IP = ? AND AUD_USER = ? AND AUD_ACTION = ? AND APPLIC_CD = ? AND AUD_DATE >= ? ORDER BY AUD_DATE DESC", new Object[]{request.getRemoteAddr(), userToUse, this.authenticationFailureCode, this.applicationCode, cutoff.getTime()}, new int[]{12, 12, 12, 12, 93}, (RowMapper)new RowMapper<Timestamp>(){
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

            public Timestamp mapRow(ResultSet resultSet, int i) throws SQLException {
                ResultSet resultSet2 = resultSet;
                int n = i;
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)resultSet2, (Object)Conversions.intObject((int)n));
                Object[] objectArray = new Object[]{this, resultSet2, Conversions.intObject((int)n), joinPoint};
                return (Timestamp)TraceLogAspect.aspectOf().traceMethod(new InspektrThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter$1$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
            }

            static {
                1.ajc$preClinit();
            }

            static final /* synthetic */ Timestamp mapRow_aroundBody0(1 ajc$this, ResultSet resultSet, int i, JoinPoint joinPoint) {
                return resultSet.getTimestamp(1);
            }

            private static /* synthetic */ void ajc$preClinit() {
                Factory factory = new Factory("InspektrThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter.java", 1.class);
                ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "mapRow", "org.jasig.cas.web.support.InspektrThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter$1", "java.sql.ResultSet:int", "resultSet:i", "java.sql.SQLException", "java.sql.Timestamp"), 94);
            }
        });
        if (failures.size() < 2) {
            return false;
        }
        return 1000.0 / (double)(((Timestamp)failures.get(0)).getTime() - ((Timestamp)failures.get(1)).getTime()) > this.getThresholdRate();
    }

    @Override
    protected void recordSubmissionFailure(HttpServletRequest request) {
    }

    @Override
    protected void recordThrottle(HttpServletRequest request) {
        super.recordThrottle(request);
        String userToUse = this.constructUsername(request, this.getUsernameParameter());
        ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
        AuditPointRuntimeInfo auditPointRuntimeInfo = new AuditPointRuntimeInfo(){
            private static final long serialVersionUID = 1L;
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

            public String asString() {
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                Object[] objectArray = new Object[]{this, joinPoint};
                return (String)TraceLogAspect.aspectOf().traceMethod(new InspektrThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter$2$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
            }

            static {
                2.ajc$preClinit();
            }

            static final /* synthetic */ String asString_aroundBody0(2 ajc$this, JoinPoint joinPoint) {
                return String.format("%s.recordThrottle()", ajc$this.getClass().getName());
            }

            private static /* synthetic */ void ajc$preClinit() {
                Factory factory = new Factory("InspektrThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter.java", 2.class);
                ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "asString", "org.jasig.cas.web.support.InspektrThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter$2", "", "", "", "java.lang.String"), 119);
            }
        };
        AuditActionContext context = new AuditActionContext(userToUse, userToUse, INSPEKTR_ACTION, this.applicationCode, new Date(), clientInfo.getClientIpAddress(), clientInfo.getServerIpAddress(), auditPointRuntimeInfo);
        this.auditTrailManager.record(context);
    }

    public final void setApplicationCode(String applicationCode) {
        this.applicationCode = applicationCode;
    }

    public final void setAuthenticationFailureCode(String authenticationFailureCode) {
        this.authenticationFailureCode = authenticationFailureCode;
    }

    protected String constructUsername(HttpServletRequest request, String usernameParameter) {
        String username = request.getParameter(usernameParameter);
        return "[username: " + (username != null ? username : "") + ']';
    }
}

