/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.view;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.support.CasAttributeEncoder;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.web.view.Cas20ResponseView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.AbstractUrlBasedView;

public class Cas30ResponseView
extends Cas20ResponseView {
    @NotNull
    private CasAttributeEncoder casAttributeEncoder;
    @NotNull
    private ServicesManager servicesManager;

    protected Cas30ResponseView(AbstractUrlBasedView view) {
        super((View)view);
    }

    @Override
    protected void prepareMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.prepareMergedOutputModel(model, request, response);
        Service service = super.getServiceFrom(model);
        RegisteredService registeredService = this.servicesManager.findServiceBy(service);
        HashMap<String, Object> attributes = new HashMap<String, Object>(this.getPrincipalAttributesAsMultiValuedAttributes(model));
        attributes.put("authenticationDate", Collections.singleton(this.getAuthenticationDate(model)));
        attributes.put("isFromNewLogin", Collections.singleton(this.isAssertionBackedByNewLogin(model)));
        attributes.put("longTermAuthenticationRequestTokenUsed", Collections.singleton(this.isRememberMeAuthentication(model)));
        this.decideIfCredentialPasswordShouldBeReleasedAsAttribute(attributes, model, registeredService);
        this.decideIfProxyGrantingTicketShouldBeReleasedAsAttribute(attributes, model, registeredService);
        super.putIntoModel(model, "attributes", (Object)this.casAttributeEncoder.encodeAttributes(attributes, this.getServiceFrom(model)));
    }

    protected void decideIfCredentialPasswordShouldBeReleasedAsAttribute(Map<String, Object> attributes, Map<String, Object> model, RegisteredService service) {
        this.decideAttributeReleaseBasedOnServiceAttributePolicy(attributes, this.getAuthenticationAttribute(model, "credential"), "credential", service, service.getAttributeReleasePolicy().isAuthorizedToReleaseCredentialPassword());
    }

    protected void decideIfProxyGrantingTicketShouldBeReleasedAsAttribute(Map<String, Object> attributes, Map<String, Object> model, RegisteredService service) {
        this.decideAttributeReleaseBasedOnServiceAttributePolicy(attributes, this.getProxyGrantingTicketId(model), "proxyGrantingTicket", service, service.getAttributeReleasePolicy().isAuthorizedToReleaseProxyGrantingTicket());
    }

    protected void decideAttributeReleaseBasedOnServiceAttributePolicy(Map<String, Object> attributes, String attributeValue, String attributeName, RegisteredService service, boolean doesAttributePolicyAllow) {
        if (StringUtils.isNotBlank((CharSequence)attributeValue)) {
            this.logger.debug("Obtained [{}] as an authentication attribute", (Object)attributeName);
            if (doesAttributePolicyAllow) {
                this.logger.debug("Obtained [{}] is passed to the CAS validation payload", (Object)attributeName);
                attributes.put(attributeName, Collections.singleton(attributeValue));
            } else {
                this.logger.debug("Attribute release policy for [{}] does not authorize the release of [{}]", (Object)service.getServiceId(), (Object)attributeName);
            }
        } else {
            this.logger.trace("[{}] is not available and will not be released to the validation response.", (Object)attributeName);
        }
    }

    public void setServicesManager(@NotNull ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }

    public void setCasAttributeEncoder(@NotNull CasAttributeEncoder casAttributeEncoder) {
        this.casAttributeEncoder = casAttributeEncoder;
    }
}

