/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.web.support.WebUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public abstract class AbstractLogoutAction
extends AbstractAction {
    public static final String LOGOUT_INDEX = "logoutIndex";
    public static final String FINISH_EVENT = "finish";
    public static final String FRONT_EVENT = "front";
    public static final String REDIRECT_APP_EVENT = "redirectApp";

    protected final Event doExecute(RequestContext context) throws Exception {
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)context);
        HttpServletResponse response = WebUtils.getHttpServletResponse((RequestContext)context);
        this.preventCaching(response);
        return this.doInternalExecute(request, response, context);
    }

    protected abstract Event doInternalExecute(HttpServletRequest var1, HttpServletResponse var2, RequestContext var3) throws Exception;

    protected final void preventCaching(HttpServletResponse response) {
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 1L);
        response.setHeader("Cache-Control", "no-cache");
        response.addHeader("Cache-Control", "no-store");
    }

    protected final void putLogoutIndex(RequestContext context, int index) {
        context.getFlowScope().put(LOGOUT_INDEX, (Object)index);
    }

    protected final int getLogoutIndex(RequestContext context) {
        Object value = context.getFlowScope().get(LOGOUT_INDEX);
        return value == null ? 0 : (Integer)value;
    }
}

