/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import java.util.LinkedHashMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.webflow.context.servlet.DefaultFlowUrlHandler;
import org.springframework.webflow.core.collection.AttributeMap;

public final class CasDefaultFlowUrlHandler
extends DefaultFlowUrlHandler {
    public static final String DEFAULT_FLOW_EXECUTION_KEY_PARAMETER = "execution";
    private String flowExecutionKeyParameter = "execution";

    public void setFlowExecutionKeyParameter(String parameterName) {
        this.flowExecutionKeyParameter = parameterName;
    }

    public String getFlowExecutionKey(HttpServletRequest request) {
        return request.getParameter(this.flowExecutionKeyParameter);
    }

    public String createFlowExecutionUrl(String flowId, String flowExecutionKey, HttpServletRequest request) {
        StringBuilder builder = new StringBuilder();
        builder.append(request.getRequestURI());
        builder.append('?');
        LinkedHashMap<String, String> flowParams = new LinkedHashMap<String, String>(request.getParameterMap());
        flowParams.put(this.flowExecutionKeyParameter, flowExecutionKey);
        this.appendQueryParameters(builder, flowParams, this.getEncodingScheme(request));
        return builder.toString();
    }

    public String createFlowDefinitionUrl(String flowId, AttributeMap input, HttpServletRequest request) {
        return request.getRequestURI() + (request.getQueryString() != null ? '?' + request.getQueryString() : "");
    }
}

