/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import java.net.URI;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.services.UnauthorizedServiceException;
import org.jasig.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public final class ServiceAuthorizationCheck
extends AbstractAction {
    @NotNull
    private final ServicesManager servicesManager;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public ServiceAuthorizationCheck(ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }

    protected Event doExecute(RequestContext context) throws Exception {
        WebApplicationService service = WebUtils.getService((RequestContext)context);
        if (service == null) {
            return this.success();
        }
        if (this.servicesManager.getAllServices().isEmpty()) {
            String msg = String.format("No service definitions are found in the service manager. Service [%s] will not be automatically authorized to request authentication.", service.getId());
            this.logger.warn(msg);
            throw new UnauthorizedServiceException("screen.service.empty.error.message");
        }
        RegisteredService registeredService = this.servicesManager.findServiceBy((Service)service);
        if (registeredService == null) {
            String msg = String.format("Service Management: Unauthorized Service Access. Service [%s] is not found in service registry.", service.getId());
            this.logger.warn(msg);
            throw new UnauthorizedServiceException("screen.service.error.message", msg);
        }
        if (!registeredService.getAccessStrategy().isServiceAccessAllowed()) {
            String msg = String.format("Service Management: Unauthorized Service Access. Service [%s] is not allowed access via the service registry.", service.getId());
            this.logger.warn(msg);
            WebUtils.putUnauthorizedRedirectUrlIntoFlowScope((RequestContext)context, (URI)registeredService.getAccessStrategy().getUnauthorizedRedirectUrl());
            throw new UnauthorizedServiceException("screen.service.error.message", msg);
        }
        return this.success();
    }
}

