/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import java.io.Serializable;
import org.springframework.webflow.execution.repository.support.CompositeFlowExecutionKey;

public final class CasFlowExecutionKey
extends CompositeFlowExecutionKey {
    public static final String KEY_SEPARATOR = "Z";
    private final String encryptedValue;

    public CasFlowExecutionKey(Serializable executionId, Serializable snapshotId, String encryptedVersion) {
        super(executionId, snapshotId);
        this.encryptedValue = encryptedVersion;
    }

    public String toString() {
        return this.encryptedValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CasFlowExecutionKey that = (CasFlowExecutionKey)o;
        return !(this.encryptedValue != null ? !this.encryptedValue.equals(that.encryptedValue) : that.encryptedValue != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.encryptedValue != null ? this.encryptedValue.hashCode() : 0);
        return result;
    }

    public static String[] keyParts(String encodedKey) {
        String[] keyParts = new String[3];
        int keySeparatorIndex = encodedKey.indexOf(KEY_SEPARATOR);
        keyParts[2] = encodedKey.substring(0, keySeparatorIndex);
        String originalKey = encodedKey.substring(keySeparatorIndex + 1);
        String[] originalKeys = CompositeFlowExecutionKey.keyParts((String)originalKey);
        keyParts[0] = originalKeys[0];
        keyParts[1] = originalKeys[1];
        return keyParts;
    }
}

