/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.maven.plugin.sass;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.jasig.maven.plugin.sass.AbstractSassMojo;
import org.jasig.maven.plugin.sass.CompilationErrors;
import org.jasig.maven.plugin.sass.Resource;

public class WatchMojo
extends AbstractSassMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        String sassScript = this.buildSassScript();
        log.debug((CharSequence)("SASS Ruby Script:\n" + sassScript));
        log.info((CharSequence)"Watching SASS Templates");
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine jruby = scriptEngineManager.getEngineByName("jruby");
        try {
            jruby.eval(sassScript);
            CompilationErrors compilationErrors = (CompilationErrors)jruby.getBindings(100).get("compilation_errors");
            if (compilationErrors.hasErrors()) {
                for (CompilationErrors.CompilationError error : compilationErrors) {
                    log.error((CharSequence)("Compilation of template " + error.filename + " failed: " + error.message));
                }
                if (this.failOnError) {
                    throw new MojoFailureException("SASS compilation encountered errors (see above for details).");
                }
            }
        }
        catch (ScriptException e) {
            throw new MojoExecutionException("Failed to execute SASS ruby script:\n" + sassScript, (Exception)e);
        }
    }

    protected String buildSassScript() throws MojoExecutionException {
        this.sassOptions.put("template_location", "'" + ((Resource)this.resources.get((int)0)).source.getDirectory() + "'");
        this.sassOptions.put("css_location", "'" + ((Resource)this.resources.get((int)0)).destination + "'");
        StringBuilder sassScript = new StringBuilder();
        this.buildBasicSASSScript(sassScript);
        sassScript.append("Sass::Plugin.watch");
        return sassScript.toString();
    }
}

