/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.openregistry.test.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.openregistry.core.domain.EmailAddress;
import org.openregistry.core.domain.Identifier;
import org.openregistry.core.domain.Person;
import org.openregistry.core.domain.Role;
import org.openregistry.core.domain.sor.SorPerson;
import org.openregistry.core.domain.sor.SorRole;
import org.openregistry.core.repository.PersonRepository;
import org.openregistry.core.repository.RepositoryAccessException;
import org.openregistry.core.service.SearchCriteria;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockPersonRepository
implements PersonRepository {
    private final List<Person> persons = new ArrayList<Person>();
    private final List<SorPerson> sorPersons = new ArrayList<SorPerson>();

    public MockPersonRepository(Person person) {
        this(new Person[]{person});
    }

    public MockPersonRepository(Person ... persons) {
        this(persons, new SorPerson[0]);
    }

    public SorRole findSorRoleByInternalId(Long id) throws RepositoryAccessException {
        return null;
    }

    public MockPersonRepository(Person[] persons, SorPerson[] sorPersons) {
        this.persons.addAll((Collection<Person>)Arrays.asList(persons));
        this.sorPersons.addAll((Collection<SorPerson>)Arrays.asList(sorPersons));
    }

    public List<Person> getPersons() {
        return this.persons;
    }

    public Person findByInternalId(Long id) throws RepositoryAccessException {
        for (Person person : this.persons) {
            if (!person.getId().equals(id)) continue;
            return person;
        }
        return null;
    }

    public SorPerson findSorByInternalId(Long id) throws RepositoryAccessException {
        for (SorPerson person : this.sorPersons) {
            if (!person.getId().equals(id)) continue;
            return person;
        }
        return null;
    }

    public Person findByIdentifier(String identifierType, String identifierValue) throws RepositoryAccessException {
        for (Person person : this.persons) {
            for (Identifier identifier : person.getIdentifiers()) {
                if (!identifier.getType().getName().equals(identifierType) || !identifier.getValue().equals(identifierValue)) continue;
                return person;
            }
        }
        throw new RepositoryAccessException();
    }

    public SorPerson findBySorIdentifierAndSource(String sorSourceIdentifier, String sorId) {
        return null;
    }

    public SorPerson findByPersonIdAndSorIdentifier(Long personId, String sorSourceIdentifier) {
        for (SorPerson sorPerson : this.sorPersons) {
            if (!sorPerson.getPersonId().equals(personId) || !sorPerson.getSourceSor().equals(sorSourceIdentifier)) continue;
            return sorPerson;
        }
        return null;
    }

    public List<Person> searchByCriteria(SearchCriteria searchCriteria) throws RepositoryAccessException {
        return this.persons;
    }

    public List<Person> findByFamilyName(String family) throws RepositoryAccessException {
        return null;
    }

    public Person savePerson(Person person) throws RepositoryAccessException {
        this.persons.add(person);
        return person;
    }

    public SorPerson saveSorPerson(SorPerson sorPerson) throws RepositoryAccessException {
        this.sorPersons.add(sorPerson);
        return sorPerson;
    }

    public void deleteSorRole(SorPerson person, SorRole role) {
        person.getRoles().remove(role);
    }

    public List<SorPerson> getSoRRecordsForPerson(Person person) {
        ArrayList<SorPerson> sorPersons = new ArrayList<SorPerson>();
        for (SorPerson sorPerson : this.sorPersons) {
            if (!sorPerson.getPersonId().equals(person.getId())) continue;
            sorPersons.add(sorPerson);
        }
        return sorPersons;
    }

    public Number getCountOfSoRRecordsForPerson(Person person) {
        return this.getSoRRecordsForPerson(person).size();
    }

    public void deleteSorPerson(SorPerson person) {
        this.sorPersons.remove(person);
    }

    public void deletePerson(Person person) {
        this.persons.remove(person);
    }

    public void updateRole(Person person, Role role) {
    }

    public SorRole saveSorRole(SorRole role) {
        return null;
    }

    public List<Person> findByEmailAddress(String email) {
        ArrayList<Person> persons = new ArrayList<Person>();
        for (Person person : this.persons) {
            block1: for (Role role : person.getRoles()) {
                for (EmailAddress emailAddress : role.getEmailAddresses()) {
                    if (!emailAddress.getAddress().equalsIgnoreCase(email)) continue;
                    persons.add(person);
                    continue block1;
                }
            }
        }
        return persons;
    }

    public List<Person> findByEmailAddressAndPhoneNumber(String email, String countryCode, String areaCode, String number) {
        return new ArrayList<Person>();
    }

    public List<Person> findByEmailAddressAndPhoneNumber(String email, String countryCode, String areaCode, String number, String extension) {
        return new ArrayList<Person>();
    }

    public List<Person> findByPhoneNumber(String countryCode, String areaCode, String number, String extension) {
        return new ArrayList<Person>();
    }

    public List<Person> findByPhoneNumber(String countryCode, String areaCode, String number) {
        return new ArrayList<Person>();
    }
}

