/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.openregistry.test.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jasig.openregistry.test.domain.MockPerson;
import org.openregistry.core.domain.Person;
import org.openregistry.core.domain.sor.ReconciliationCriteria;
import org.openregistry.core.domain.sor.SorPerson;
import org.openregistry.core.service.reconciliation.FieldMatch;
import org.openregistry.core.service.reconciliation.PersonMatch;
import org.openregistry.core.service.reconciliation.Reconciler;
import org.openregistry.core.service.reconciliation.ReconciliationResult;

public final class MockReconciler
implements Reconciler {
    private ReconciliationResult.ReconciliationType desiredResult;

    public MockReconciler() {
    }

    public MockReconciler(ReconciliationResult.ReconciliationType result) {
        if (result == null) {
            throw new IllegalArgumentException("result cannot be null.");
        }
        this.desiredResult = result;
    }

    public void setReconciliationType(ReconciliationResult.ReconciliationType reconciliationType) {
        this.desiredResult = reconciliationType;
    }

    public ReconciliationResult reconcile(ReconciliationCriteria reconciliationCriteria) {
        return new ReconciliationResult(){

            public ReconciliationResult.ReconciliationType getReconciliationType() {
                return MockReconciler.this.desiredResult;
            }

            public List<PersonMatch> getMatches() {
                ArrayList<PersonMatch> exactMatch = new ArrayList<PersonMatch>();
                ArrayList<PersonMatch> severalMatch = new ArrayList<PersonMatch>();
                PersonMatch personMatch = new PersonMatch(){

                    public List<FieldMatch> getFieldMatches() {
                        return Collections.emptyList();
                    }

                    public int getConfidenceLevel() {
                        return 0;
                    }

                    public Person getPerson() {
                        return new MockPerson();
                    }

                    public int compareTo(PersonMatch personMatch) {
                        int level = this.getConfidenceLevel() - personMatch.getConfidenceLevel();
                        if (level == 0) {
                            int result = this.getPerson().getOfficialName().getFamily().compareTo(personMatch.getPerson().getOfficialName().getFamily());
                            return result == 0 ? this.getPerson().getOfficialName().getGiven().compareTo(personMatch.getPerson().getOfficialName().getGiven()) : result;
                        }
                        return level;
                    }
                };
                exactMatch.add(personMatch);
                severalMatch.add(personMatch);
                severalMatch.add(personMatch);
                if (MockReconciler.this.desiredResult.equals((Object)ReconciliationResult.ReconciliationType.EXACT)) {
                    return exactMatch;
                }
                if (MockReconciler.this.desiredResult.equals((Object)ReconciliationResult.ReconciliationType.MAYBE)) {
                    return severalMatch;
                }
                return Collections.emptyList();
            }

            public boolean noPeopleFound() {
                return MockReconciler.this.desiredResult.equals((Object)ReconciliationResult.ReconciliationType.NONE);
            }

            public boolean personAlreadyExists() {
                return MockReconciler.this.desiredResult.equals((Object)ReconciliationResult.ReconciliationType.EXACT);
            }

            public boolean multiplePeopleFound() {
                return MockReconciler.this.desiredResult.equals((Object)ReconciliationResult.ReconciliationType.MAYBE);
            }
        };
    }

    public boolean reconcilesToSamePerson(SorPerson sorPerson) {
        return true;
    }
}

