/**
 * Licensed to Jasig under one or more contributor license
 * agreements. See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Jasig licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a
 * copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.jasig.portal.groups.pags.testers;

import org.apache.oro.text.perl.Perl5Util;


/**
 * A tester for matching the possibly multiple values of an attribute 
 * against a regular expression.  If any of the values matches the pattern, 
 * the tester returns true.
 * <p>
 * @author Dan Ellentuck
 * @version $Revision: 19776 $
 */

public class RegexTester extends StringTester {
    protected Perl5Util regexMatcher = null;
    protected String pattern = null;
    protected char PATTERN_DELIMITER = '/';
    
public RegexTester(String attribute, String test) {
    super(attribute, test);
    initialize();
}
protected void initialize() {
    regexMatcher = new Perl5Util();
    pattern = PATTERN_DELIMITER + testValue + PATTERN_DELIMITER; 
}
public boolean test(String att) {
    boolean result = false;
    try
        { result = regexMatcher.match(pattern,att); }
    catch ( Throwable t ) { }  // Bad pattern?
    return result; 
}

}
