/**
 * Licensed to Jasig under one or more contributor license
 * agreements. See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Jasig licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a
 * copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.jasig.portal.security.provider;

import java.io.Serializable;

import org.jasig.portal.security.*;

import javax.security.auth.*;

/**
 * Simple container object for a JAAS Subject for the logged in user.
 * 
 * @author Al Wold
 * @version $Revision: 19776 $
 *
 */
public class JAASSubject implements IAdditionalDescriptor, Serializable {
   private Subject subject;
   
   public JAASSubject(Subject subject) {
      this.subject = subject;
   }
   
   public Subject getSubject() {
      return subject;
   }
}
