/**
 * Licensed to Jasig under one or more contributor license
 * agreements. See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Jasig licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a
 * copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.jasig.portal.utils;

/**
 * A store interface that keeps track of multiple unique ID counters.
 *
 * @author Peter Kharchenko  {@link <a href="mailto:pkharchenko@interactivebusiness.com"">pkharchenko@interactivebusiness.com"</a>}
 * @version $Revision: 19776 $
 */
public interface ICounterStore {

    /**
     * Create a new coutner
     *
     * @param counterName a name for the new counter
     * @exception Exception if an error occurs
     */
    public void createCounter(String counterName) throws Exception;

    /**
     * Reset a value of a counter.
     *
     * @param counterName a counter name
     * @param value a new counter value
     * @exception Exception if an error occurs
     */
    public void setCounter(String counterName, int value) throws Exception;

    /**
     * Obtain current coutner value and increment it.
     *
     * @param counterName a <code>String</code> value
     * @return an <code>int</code> value
     * @exception Exception if an error occurs
     */
    public int getIncrementIntegerId(String counterName) throws Exception;

}
