/**
 * Licensed to Jasig under one or more contributor license
 * agreements. See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Jasig licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a
 * copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.jasig.portal.utils.web;

import java.io.Serializable;

import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;

/**
 * Servlet 2.3 HttpSessionListener that automatically exposes the
 * request attribute mutex when an ServletRequest gets created.
 * To be registered as a listener in <code>web.xml</code>.
 *
 * <p>The request attribute mutex is guaranteed to be the same object during
 * the entire lifetime of the request, available under the key defined
 * by the <code>REQUEST_MUTEX_ATTRIBUTE</code> constant. It serves as a
 * safe reference to synchronize on for locking on the current request attributes.
 * 
 * @author Eric Dalquist
 * @version $Revision: 19776 $
 */
public class RequestAttributeMutexListener implements ServletRequestListener {

    /* (non-Javadoc)
     * @see javax.servlet.ServletRequestListener#requestInitialized(javax.servlet.ServletRequestEvent)
     */
    public void requestInitialized(ServletRequestEvent sre) {
        sre.getServletRequest().setAttribute(PortalWebUtils.REQUEST_MUTEX_ATTRIBUTE, new Mutex());
    }

    /* (non-Javadoc)
     * @see javax.servlet.ServletRequestListener#requestDestroyed(javax.servlet.ServletRequestEvent)
     */
    public void requestDestroyed(ServletRequestEvent sre) {
        sre.getServletRequest().removeAttribute(PortalWebUtils.REQUEST_MUTEX_ATTRIBUTE);
    }

    /**
     * The mutex to be registered.
     * Doesn't need to be anything but a plain Object to synchronize on.
     */
    private static class Mutex implements Serializable {
        private static final long serialVersionUID = 1L;
    }
}
