/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.BrowserInfo;
import org.jasig.portal.ChannelCacheEntry;
import org.jasig.portal.ChannelFactory;
import org.jasig.portal.ChannelRendererFactory;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelSAXStreamFilter;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.IAnchoringSerializer;
import org.jasig.portal.ICCRegistry;
import org.jasig.portal.ICacheable;
import org.jasig.portal.IChannel;
import org.jasig.portal.IChannelRenderer;
import org.jasig.portal.IChannelRendererFactory;
import org.jasig.portal.IPrivileged;
import org.jasig.portal.IUserPreferencesManager;
import org.jasig.portal.InternalPortalException;
import org.jasig.portal.PortalControlStructures;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.PortalException;
import org.jasig.portal.StructureStylesheetUserPreferences;
import org.jasig.portal.UPFileSpec;
import org.jasig.portal.UserPreferences;
import org.jasig.portal.UserProfile;
import org.jasig.portal.channels.CSecureInfo;
import org.jasig.portal.channels.error.CError;
import org.jasig.portal.channels.error.ErrorCode;
import org.jasig.portal.channels.support.IDynamicChannelTitleRenderer;
import org.jasig.portal.events.EventPublisherLocator;
import org.jasig.portal.events.support.ChannelInstanciatedInLayoutPortalEvent;
import org.jasig.portal.events.support.ChannelRenderedInLayoutPortalEvent;
import org.jasig.portal.events.support.ChannelTargetedInLayoutPortalEvent;
import org.jasig.portal.events.support.PortletActionInLayoutPortalEvent;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.jndi.IJndiManager;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.LayoutEvent;
import org.jasig.portal.layout.LayoutEventListener;
import org.jasig.portal.layout.LayoutMoveEvent;
import org.jasig.portal.layout.node.IUserLayoutChannelDescription;
import org.jasig.portal.layout.node.IUserLayoutNodeDescription;
import org.jasig.portal.portlet.url.RequestType;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.serialize.CachingSerializer;
import org.jasig.portal.services.AuthorizationService;
import org.jasig.portal.spring.PortalApplicationContextLocator;
import org.jasig.portal.spring.locator.ChannelRequestParameterManagerLocator;
import org.jasig.portal.spring.locator.JndiManagerLocator;
import org.jasig.portal.url.support.IChannelRequestParameterManager;
import org.jasig.portal.utils.SAX2BufferImpl;
import org.jasig.portal.utils.SetCheckInSemaphore;
import org.jasig.portal.utils.web.PortalWebUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.jndi.JndiTemplate;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import tyrex.naming.MemoryContext;

@Deprecated
public class ChannelManager
implements LayoutEventListener {
    private static final String PORTAL_CONTROL_STRUCTURES_MAP_ATTR = ChannelManager.class.getName() + ".PortalControlStructuresMap";
    public static final String channelAddressingPathElement = "channel";
    private static final AtomicLong activeRenderers = new AtomicLong();
    private static final AtomicLong maxRenderThreads = new AtomicLong();
    private static final IChannelRendererFactory cChannelRendererFactory = ChannelRendererFactory.newInstance(ChannelManager.class.getName(), activeRenderers, maxRenderThreads);
    private static boolean useAnchors = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.ChannelManager.use_anchors", false);
    private static final Log log = LogFactory.getLog(ChannelManager.class);
    private final IUserPreferencesManager userPreferencesManager;
    private final Map<String, IChannel> channelTable = new Hashtable<String, IChannel>();
    private final Map<String, IChannelRenderer> rendererTable = new Hashtable<String, IChannelRenderer>();
    private final Map<IChannel, Map<String, ChannelCacheEntry>> channelCacheTable = Collections.synchronizedMap(new WeakHashMap());
    private final Set<String> repeatRenderings = new HashSet<String>();
    private final Map<String, Set<String>> iccTalkers = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> iccListeners = new HashMap<String, Set<String>>();
    private final Context channelContext;
    private final IAuthorizationPrincipal authorizationPrincipal;
    private final Set<String> pendingChannels = new HashSet<String>();
    private String channelTarget;
    private Map<String, Object> targetParams;
    private UPFileSpec uPElement;
    private boolean characterCaching = false;
    private BrowserInfo browserInfo;
    private LocaleManager localeManager;
    private String serializerName;
    private boolean groupedRendering = false;

    public static long getActiveRenderers() {
        return activeRenderers.get();
    }

    public static long getMaxRenderThreads() {
        return maxRenderThreads.get();
    }

    public ChannelManager(IUserPreferencesManager manager, HttpSession httpSession) {
        this.userPreferencesManager = manager;
        String sessionId = httpSession.getId();
        IPerson person = this.userPreferencesManager.getPerson();
        String personId = Integer.toString(person.getID());
        UserProfile currentProfile = this.userPreferencesManager.getCurrentProfile();
        String layoutId = Integer.toString(currentProfile.getLayoutId());
        this.channelContext = this.getChannelJndiContext(sessionId, personId, layoutId);
        EntityIdentifier personEntityIdentifier = person.getEntityIdentifier();
        this.authorizationPrincipal = AuthorizationService.instance().newPrincipal(personEntityIdentifier.getKey(), personEntityIdentifier.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context getChannelJndiContext(String sessionId, String userId, String layoutId) {
        IJndiManager jndiManager = JndiManagerLocator.getJndiManager();
        JndiTemplate jndiTemplate = jndiManager.getJndiTemplate();
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            ClassLoader portalClassLoader = this.getClass().getClassLoader();
            currentThread.setContextClassLoader(portalClassLoader);
            MemoryContext cic = new MemoryContext(new Hashtable());
            Context servicesContext = (Context)jndiTemplate.lookup("services", Context.class);
            Context channel_idsContext = (Context)jndiTemplate.lookup("users/" + userId + "/layouts/" + layoutId + "/channel-ids", Context.class);
            Context channel_objContext = (Context)jndiTemplate.lookup("users/" + userId + "/sessions/" + sessionId + "/channel-obj", Context.class);
            cic.bind("services", (Object)servicesContext);
            cic.bind("channel-ids", (Object)channel_idsContext);
            cic.bind("channel-obj", (Object)channel_objContext);
            cic.bind("portlet-ids", new ArrayList());
            MemoryContext memoryContext = cic;
            return memoryContext;
        }
        catch (NamingException ne) {
            log.warn((Object)"Failed to create channel JNDI Context. No JNDI context will be available for inter-channel-communication.", (Throwable)ne);
            Context context = null;
            return context;
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PortalControlStructures getPortalControlStructuresForChannel(HttpServletRequest request, HttpServletResponse response, String channelSubscribeId) {
        HashMap<String, PortalControlStructures> existingPortalControlStructures;
        HashMap<String, PortalControlStructures> hashMap = PortalWebUtils.getRequestAttributeMutex((ServletRequest)request);
        synchronized (hashMap) {
            existingPortalControlStructures = (HashMap<String, PortalControlStructures>)request.getAttribute(PORTAL_CONTROL_STRUCTURES_MAP_ATTR);
            if (existingPortalControlStructures == null) {
                existingPortalControlStructures = new HashMap<String, PortalControlStructures>();
                request.setAttribute(PORTAL_CONTROL_STRUCTURES_MAP_ATTR, existingPortalControlStructures);
            }
        }
        hashMap = existingPortalControlStructures;
        synchronized (hashMap) {
            PortalControlStructures pcs = (PortalControlStructures)existingPortalControlStructures.get(channelSubscribeId);
            if (pcs == null) {
                pcs = new PortalControlStructures(request, response, this, this.userPreferencesManager);
                existingPortalControlStructures.put(channelSubscribeId, pcs);
            }
            return pcs;
        }
    }

    public void setChannelInstance(String channelSubscribeId, IChannel channelInstance) {
        if (this.channelTable.get(channelSubscribeId) != null) {
            this.channelTable.remove(channelSubscribeId);
        }
        this.channelTable.put(channelSubscribeId, channelInstance);
    }

    public void commitToRenderingChannelSet() {
        if (this.groupedRendering) {
            IChannelRenderer cr;
            HashSet<String> s0 = new HashSet<String>();
            if (this.pendingChannels.contains(this.channelTarget)) {
                s0.add(this.channelTarget);
                this.pendingChannels.remove(this.channelTarget);
                Set<String> children = this.getListeningChannels(this.channelTarget);
                if (children != null && !children.isEmpty()) {
                    children.retainAll(this.pendingChannels);
                    while (!children.isEmpty()) {
                        HashSet<String> newChildren = new HashSet<String>();
                        for (String childId : children) {
                            s0.add(childId);
                            this.pendingChannels.remove(childId);
                            Set<String> currentChildren = this.getListeningChannels(childId);
                            if (currentChildren == null) continue;
                            newChildren.addAll(currentChildren);
                        }
                        newChildren.retainAll(this.pendingChannels);
                        children = newChildren;
                    }
                }
            }
            SetCheckInSemaphore s0semaphore = new SetCheckInSemaphore(new HashSet(s0));
            for (String channelSubscribeId : s0) {
                cr = this.rendererTable.get(channelSubscribeId);
                cr.startRendering(s0semaphore, channelSubscribeId);
            }
            for (String channelSubscribeId : this.pendingChannels) {
                cr = this.rendererTable.get(channelSubscribeId);
                cr.startRendering();
            }
        }
    }

    public void finishedRenderingCycle() {
        for (IChannelRenderer channelRenderer : this.rendererTable.values()) {
            try {
                channelRenderer.kill();
            }
            catch (Throwable t) {
                log.error((Object)("Error cleaning up runaway channel renderer: [" + channelRenderer + "]"), t);
            }
        }
        this.rendererTable.clear();
        this.repeatRenderings.clear();
        this.pendingChannels.clear();
        this.targetParams = null;
        this.groupedRendering = false;
    }

    public void finishedSession(HttpSession session) {
        this.finishedRenderingCycle();
        PortalControlStructures pcs = new PortalControlStructures(session, this, this.userPreferencesManager);
        PortalEvent ev = PortalEvent.SESSION_DONE_EVENT;
        for (IChannel ch : this.channelTable.values()) {
            if (ch == null) continue;
            try {
                if (ch instanceof IPrivileged) {
                    ((IPrivileged)((Object)ch)).setPortalControlStructures(pcs);
                }
                ch.receiveEvent(ev);
            }
            catch (Exception e) {
                log.error((Object)("Error sending session done event to channel " + ch), (Throwable)e);
            }
        }
        this.channelTable.clear();
        this.channelCacheTable.clear();
        this.iccTalkers.clear();
        this.iccListeners.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void outputChannel(HttpServletRequest request, HttpServletResponse response, String channelSubscribeId, ContentHandler contentHandler) {
        IChannelRenderer cr;
        block32: {
            int renderingStatus;
            block33: {
                if (useAnchors && contentHandler instanceof IAnchoringSerializer) {
                    IAnchoringSerializer as = (IAnchoringSerializer)((Object)contentHandler);
                    as.startAnchoring(channelSubscribeId);
                }
                if ((cr = this.rendererTable.get(channelSubscribeId)) == null) {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Getting output - no channel renderer for subscribe id: " + channelSubscribeId + ", starting rendering"));
                        }
                        cr = this.startChannelRendering(request, response, channelSubscribeId);
                    }
                    catch (PortalException pe) {
                        log.error((Object)"Encountered a portal exception while trying to start channel rendering! :", (Throwable)pe);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Getting output - Retrieved channel renderer " + cr.toString() + " for subscribe id: " + channelSubscribeId));
                }
                renderingStatus = -1;
                try {
                    renderingStatus = cr.completeRendering();
                }
                catch (Throwable t) {
                    this.handleRenderingError(request, response, channelSubscribeId, contentHandler, t, renderingStatus, "encountered problem while trying to complete rendering", "IChannelRenderer.completeRendering() threw", false);
                    return;
                }
                if (renderingStatus != 0) {
                    this.handleRenderingError(request, response, channelSubscribeId, contentHandler, null, renderingStatus, "unsuccessful rendering", "unsuccessful rendering", false);
                    return;
                }
                if (!(contentHandler instanceof CachingSerializer) || !this.characterCaching) break block33;
                CachingSerializer cs = (CachingSerializer)contentHandler;
                String characterContent = cr.getCharacters();
                if (characterContent == null) {
                    SAX2BufferImpl bufferedContent = cr.getBuffer();
                    if (bufferedContent == null) {
                        this.handleRenderingError(request, response, channelSubscribeId, contentHandler, null, renderingStatus, "unable to obtain channel rendering", "IChannelRenderer.getBuffer() returned null", false);
                        return;
                    }
                    try {
                        if (!cs.startCaching()) {
                            log.error((Object)("unable to restart character cache while compiling character cache for channel '" + channelSubscribeId + "' !"));
                        }
                        bufferedContent.outputBuffer(contentHandler);
                        if (!cs.stopCaching()) {
                            log.error((Object)("unable to reset cache state while compiling character cache for channel '" + channelSubscribeId + "' ! Serializer was not caching when it should've been ! Partial output possible!"));
                            return;
                        }
                        try {
                            characterContent = cs.getCache();
                            log.debug((Object)("outputChannel 2: " + characterContent));
                            if (characterContent != null) {
                                cr.setCharacterCache(characterContent);
                            }
                            log.error((Object)("character caching serializer returned NULL character cache for channel '" + channelSubscribeId + "' !"));
                        }
                        catch (UnsupportedEncodingException e) {
                            log.error((Object)("unable to compile character cache for channel '" + channelSubscribeId + "'! Invalid encoding specified."), (Throwable)e);
                        }
                        catch (IOException ioe) {
                            log.error((Object)("IO exception occurred while compiling character cache for channel '" + channelSubscribeId + "' !"), (Throwable)ioe);
                        }
                    }
                    catch (IOException ioe) {
                        this.handleRenderingError(request, response, channelSubscribeId, contentHandler, ioe, renderingStatus, "encountered a problem compiling channel character content", "Encountered IO exception while trying to output channel content SAX to the character caching serializer", true);
                        return;
                    }
                    catch (SAXException se) {
                        this.handleRenderingError(request, response, channelSubscribeId, contentHandler, se, renderingStatus, "encountered a problem compiling channel character content", "Encountered SAX exception while trying to output channel content SAX to the character caching serializer", true);
                        return;
                    }
                } else {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Getting output - Writing " + characterContent.length() + " characters for " + cr.toString() + " for subscribe id: " + channelSubscribeId));
                        }
                        cs.printRawCharacters(characterContent);
                    }
                    catch (IOException ioe) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("exception thrown while trying to output character cache for channelSubscribeId='" + channelSubscribeId + "'"), (Throwable)ioe);
                        }
                        break block32;
                    }
                }
            }
            SAX2BufferImpl bufferedContent = cr.getBuffer();
            if (bufferedContent == null) {
                this.handleRenderingError(request, response, channelSubscribeId, contentHandler, null, renderingStatus, "unable to obtain channel rendering", "IChannelRenderer.getBuffer() returned null", false);
                return;
            }
            try {
                ChannelSAXStreamFilter custodian = new ChannelSAXStreamFilter(contentHandler);
                bufferedContent.outputBuffer(custodian);
            }
            catch (Exception e) {
                log.error((Object)("encountered an exception while trying to output SAX2 content of channel '" + channelSubscribeId + "' to a regular serializer. Partial output possible !"), (Throwable)e);
                return;
            }
        }
        if (useAnchors && contentHandler instanceof IAnchoringSerializer) {
            IAnchoringSerializer as = (IAnchoringSerializer)((Object)contentHandler);
            as.stopAnchoring();
        }
        IUserLayoutChannelDescription channelDesc = null;
        IUserLayoutNodeDescription parentNode = null;
        try {
            IUserLayoutManager userLayoutManager = this.userPreferencesManager.getUserLayoutManager();
            channelDesc = (IUserLayoutChannelDescription)userLayoutManager.getNode(channelSubscribeId);
            String parentNodeId = userLayoutManager.getParentId(channelDesc.getId());
            if (parentNodeId != null) {
                parentNode = userLayoutManager.getNode(parentNodeId);
            }
        }
        catch (PortalException pe) {
            log.warn((Object)("Failed to load IUserLayoutChannelDescription and parent IUserLayoutNodeDescription for channel with subscribe id: " + channelSubscribeId), (Throwable)pe);
        }
        IPerson person = this.userPreferencesManager.getPerson();
        UserProfile userProfile = this.userPreferencesManager.getCurrentProfile();
        long renderTime = cr.getRenderTime();
        boolean renderedFromCache = cr.isRenderedFromCache();
        ChannelRenderedInLayoutPortalEvent channelRenderedEvent = new ChannelRenderedInLayoutPortalEvent((Object)this, person, userProfile, channelDesc, parentNode, renderTime, renderedFromCache);
        EventPublisherLocator.getApplicationEventPublisher().publishEvent((ApplicationEvent)channelRenderedEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRenderingError(HttpServletRequest request, HttpServletResponse response, String channelSubscribeId, ContentHandler contentHandler, Throwable t, int renderingStatus, String commonMessage, String technicalMessage, boolean partialOutput) {
        try {
            if (this.repeatRenderings.contains(channelSubscribeId)) {
                String message = "Unable to handle a rendering error through error channel.";
                if (t != null) {
                    if (t instanceof InternalPortalException) {
                        InternalPortalException ipe = (InternalPortalException)t;
                        Throwable e = ipe.getCause();
                        message = message + " Error channel (channelSubscribeId='" + channelSubscribeId + "') has thrown the following exception: " + e.toString() + " Partial output possible !";
                        log.fatal((Object)"CError threw exception. Please fix CError immediately!", e);
                    } else {
                        message = message + " An following exception encountered while trying to render the error channel for channelSubscribeId='" + channelSubscribeId + "': " + t.toString();
                        log.fatal((Object)"CError threw exception. Please fix CError immediately!", t);
                    }
                } else {
                    message = message + " channelRenderingStatus=";
                    switch (renderingStatus) {
                        case 0: {
                            message = message + "successful";
                            break;
                        }
                        case 1: {
                            message = message + "failed";
                            break;
                        }
                        case 2: {
                            message = message + "timed out";
                            break;
                        }
                        default: {
                            message = message + "UNKNOWN CODE: " + renderingStatus;
                        }
                    }
                }
                message = message + " " + technicalMessage;
                log.error((Object)message);
            } else {
                if (t != null) {
                    if (t instanceof InternalPortalException) {
                        InternalPortalException ipe = (InternalPortalException)t;
                        Throwable channelException = ipe.getCause();
                        this.replaceWithErrorChannel(request, response, channelSubscribeId, ErrorCode.RENDER_TIME_EXCEPTION, channelException, technicalMessage, true);
                    } else {
                        this.replaceWithErrorChannel(request, response, channelSubscribeId, ErrorCode.RENDER_TIME_EXCEPTION, t, technicalMessage, true);
                    }
                } else if (renderingStatus == 2) {
                    this.replaceWithErrorChannel(request, response, channelSubscribeId, ErrorCode.TIMEOUT_EXCEPTION, t, technicalMessage, true);
                } else {
                    this.replaceWithErrorChannel(request, response, channelSubscribeId, ErrorCode.GENERAL_ERROR, t, technicalMessage, true);
                }
                this.rendererTable.remove(channelSubscribeId);
                if (!partialOutput) {
                    this.repeatRenderings.add(channelSubscribeId);
                    this.outputChannel(request, response, channelSubscribeId, contentHandler);
                }
            }
        }
        finally {
            if (useAnchors && contentHandler instanceof IAnchoringSerializer) {
                IAnchoringSerializer as = (IAnchoringSerializer)((Object)contentHandler);
                as.stopAnchoring();
            }
        }
    }

    private IChannel replaceWithErrorChannel(HttpServletRequest request, HttpServletResponse response, String channelSubscribeId, ErrorCode errorCode, Throwable t, String message, boolean setRuntimeData) {
        IChannel oldInstance = this.channelTable.get(channelSubscribeId);
        if (log.isWarnEnabled()) {
            log.warn((Object)("Replacing channel [" + oldInstance + "], which had subscribeId [" + channelSubscribeId + "] with error channel because of error code " + errorCode + " message: " + message + " and throwable [" + t + "]"), t);
        }
        this.channelTable.remove(channelSubscribeId);
        this.rendererTable.remove(channelSubscribeId);
        CError errorChannel = new CError(errorCode, t, channelSubscribeId, oldInstance, message);
        if (setRuntimeData) {
            ChannelRuntimeData rd = new ChannelRuntimeData();
            rd.setBrowserInfo(this.browserInfo);
            if (this.localeManager != null) {
                rd.setLocales(this.localeManager.getLocales());
            }
            PortalControlStructures pcs = this.getPortalControlStructuresForChannel(request, response, channelSubscribeId);
            rd.setRemoteAddress(pcs.getHttpServletRequest().getRemoteAddr());
            rd.setHttpRequestMethod(pcs.getHttpServletRequest().getMethod());
            UPFileSpec up = new UPFileSpec(this.uPElement);
            up.setTargetNodeId(channelSubscribeId);
            rd.setUPFile(up);
            try {
                errorChannel.setRuntimeData(rd);
                errorChannel.setPortalControlStructures(pcs);
            }
            catch (Throwable e) {
                log.error((Object)"Encountered an exception while trying to set runtime data or portal control structures on the error channel!", e);
            }
        }
        this.channelTable.put(channelSubscribeId, errorChannel);
        return errorChannel;
    }

    private IChannel replaceWithSecureInfoChannel(HttpServletRequest request, HttpServletResponse response, String channelSubscribeId, boolean setRuntimeData) {
        IChannel oldInstance = this.channelTable.get(channelSubscribeId);
        this.channelTable.remove(channelSubscribeId);
        this.rendererTable.remove(channelSubscribeId);
        CSecureInfo secureInfoChannel = new CSecureInfo(channelSubscribeId, oldInstance);
        if (setRuntimeData) {
            ChannelRuntimeData rd = new ChannelRuntimeData();
            rd.setBrowserInfo(this.browserInfo);
            if (this.localeManager != null) {
                rd.setLocales(this.localeManager.getLocales());
            }
            PortalControlStructures pcs = this.getPortalControlStructuresForChannel(request, response, channelSubscribeId);
            rd.setHttpRequestMethod(pcs.getHttpServletRequest().getMethod());
            rd.setRemoteAddress(pcs.getHttpServletRequest().getRemoteAddr());
            UPFileSpec up = new UPFileSpec(this.uPElement);
            up.setTargetNodeId(channelSubscribeId);
            rd.setUPFile(up);
            try {
                secureInfoChannel.setRuntimeData(rd);
                secureInfoChannel.setPortalControlStructures(pcs);
            }
            catch (Throwable e) {
                log.error((Object)"Encountered an exception while trying to set runtime data or portal control structures on the secure info channel!", e);
            }
        }
        this.channelTable.put(channelSubscribeId, secureInfoChannel);
        return secureInfoChannel;
    }

    public IChannel instantiateChannel(HttpServletRequest request, HttpServletResponse response, String channelSubscribeId) throws PortalException {
        IUserLayoutManager userLayoutManager;
        IUserLayoutChannelDescription channel;
        if (this.channelTable.get(channelSubscribeId) != null) {
            this.channelTable.remove(channelSubscribeId);
        }
        if ((channel = (IUserLayoutChannelDescription)(userLayoutManager = this.userPreferencesManager.getUserLayoutManager()).getNode(channelSubscribeId)) != null) {
            return this.instantiateChannel(request, response, channel);
        }
        return null;
    }

    private IChannel instantiateChannel(HttpServletRequest request, HttpServletResponse response, IUserLayoutChannelDescription channelDescription) throws PortalException {
        IChannel channel;
        String channelSubscribeId = channelDescription.getChannelSubscribeId();
        String channelPublishId = channelDescription.getChannelPublishId();
        if (this.authorizationPrincipal.canRender(Integer.parseInt(channelPublishId))) {
            if (request == null) {
                channel = new CError(ErrorCode.GENERAL_ERROR, "Unable to get SessionId. No HttpServletRequest provided.", channelSubscribeId, null);
            } else {
                HttpSession session = request.getSession();
                String sessionId = session.getId();
                channel = ChannelFactory.instantiateLayoutChannel(channelDescription, sessionId);
                if (channel == null) {
                    throw new IllegalStateException("ChannelFactory returned null on request to instantiate layout channel with id [" + sessionId + "] and description [" + channelDescription + "]");
                }
                IPerson person = this.userPreferencesManager.getPerson();
                ApplicationEventPublisher applicationEventPublisher = EventPublisherLocator.getApplicationEventPublisher();
                UserProfile currentProfile = this.userPreferencesManager.getCurrentProfile();
                IUserLayoutNodeDescription parentNode = null;
                try {
                    IUserLayoutManager userLayoutManager = this.userPreferencesManager.getUserLayoutManager();
                    String parentNodeId = userLayoutManager.getParentId(channelDescription.getId());
                    if (parentNodeId != null) {
                        parentNode = userLayoutManager.getNode(parentNodeId);
                    }
                }
                catch (PortalException pe) {
                    log.warn((Object)("Failed to load parent IUserLayoutNodeDescription for channel with subscribe id: " + channelDescription.getChannelPublishId()), (Throwable)pe);
                }
                applicationEventPublisher.publishEvent((ApplicationEvent)new ChannelInstanciatedInLayoutPortalEvent(this, person, currentProfile, channelDescription, parentNode));
                ChannelStaticData channelStaticData = new ChannelStaticData(channelDescription.getParameterMap(), this.userPreferencesManager.getUserLayoutManager());
                channelStaticData.setChannelSubscribeId(channelSubscribeId);
                channelStaticData.setTimeout(channelDescription.getTimeout());
                channelStaticData.setPerson(person);
                channelStaticData.setJNDIContext(this.channelContext);
                channelStaticData.setICCRegistry(new ICCRegistry(this, channelSubscribeId));
                channelStaticData.setChannelPublishId(channelDescription.getChannelPublishId());
                channelStaticData.setSerializerName(this.serializerName);
                channelStaticData.setWebApplicationContext(PortalApplicationContextLocator.getRequiredWebApplicationContext());
                if (channel instanceof IPrivileged) {
                    this.feedPortalControlStructuresToChannel(request, response, channelSubscribeId, (IPrivileged)((Object)channel));
                }
                channel.setStaticData(channelStaticData);
            }
        } else {
            channel = new CError(ErrorCode.CHANNEL_AUTHORIZATION_EXCEPTION, "You don't have authorization to render this channel.", channelSubscribeId, null);
        }
        this.channelTable.put(channelSubscribeId, channel);
        return channel;
    }

    public void passPortalEvent(HttpServletRequest request, HttpServletResponse response, String channelSubscribeId, PortalEvent le) {
        IChannel ch = this.getChannelInstance(request, response, channelSubscribeId);
        try {
            if (ch instanceof IPrivileged) {
                PortalControlStructures pcs = this.getPortalControlStructuresForChannel(request, response, channelSubscribeId);
                ((IPrivileged)((Object)ch)).setPortalControlStructures(pcs);
            }
            ch.receiveEvent(le);
        }
        catch (Exception e) {
            log.error((Object)("Error sending layout event " + le + " to channel " + ch), (Throwable)e);
        }
    }

    private void processRequestChannelParameters(HttpServletRequest request, HttpServletResponse response) {
        IChannelRequestParameterManager channelParameterManager = ChannelRequestParameterManagerLocator.getChannelRequestParameterManager();
        Set<String> targetedChannelIds = channelParameterManager.getTargetedChannelIds(request);
        this.channelTarget = targetedChannelIds.size() > 0 ? targetedChannelIds.iterator().next() : null;
        if (this.channelTarget != null) {
            IChannel channel;
            Map<String, Object[]> channelParameters;
            IUserLayoutChannelDescription channelDesc = null;
            IUserLayoutNodeDescription parentNode = null;
            try {
                IUserLayoutManager userLayoutManager = this.userPreferencesManager.getUserLayoutManager();
                channelDesc = (IUserLayoutChannelDescription)userLayoutManager.getNode(this.channelTarget);
                String parentNodeId = userLayoutManager.getParentId(channelDesc.getId());
                if (parentNodeId != null) {
                    parentNode = userLayoutManager.getNode(parentNodeId);
                }
            }
            catch (PortalException pe) {
                log.warn((Object)("Failed to load IUserLayoutChannelDescription and parent IUserLayoutNodeDescription for channel with subscribe id: " + this.channelTarget), (Throwable)pe);
            }
            IPerson person = this.userPreferencesManager.getPerson();
            if (channelDesc != null) {
                ApplicationEventPublisher applicationEventPublisher = EventPublisherLocator.getApplicationEventPublisher();
                UserProfile currentProfile = this.userPreferencesManager.getCurrentProfile();
                applicationEventPublisher.publishEvent((ApplicationEvent)new ChannelTargetedInLayoutPortalEvent(this, person, currentProfile, channelDesc, parentNode));
            }
            this.targetParams = (channelParameters = channelParameterManager.getChannelParameters(request, this.channelTarget)) != null ? new HashMap<String, Object[]>(channelParameters) : null;
            if (channelParameters != null && channelParameters.size() > 0) {
                this.groupedRendering = this.hasListeningChannels(this.channelTarget);
            }
            if ((channel = this.channelTable.get(this.channelTarget)) == null) {
                try {
                    channel = this.instantiateChannel(request, response, this.channelTarget);
                }
                catch (Throwable e) {
                    if (person.isGuest()) {
                        log.warn((Object)("unable to pass find/create an instance of a channel. Bogus Id ? ! (id='" + this.channelTarget + "')."));
                    } else {
                        log.error((Object)("unable to pass find/create an instance of a channel. Bogus Id ? ! (id='" + this.channelTarget + "' uid='" + person.getID() + "')."), e);
                    }
                    channel = this.replaceWithErrorChannel(request, response, this.channelTarget, ErrorCode.SET_STATIC_DATA_EXCEPTION, e, null, false);
                }
            }
        }
    }

    private IChannel feedPortalControlStructuresToChannel(HttpServletRequest request, HttpServletResponse response, String channelSubscribeId, IPrivileged prvChanObj) {
        PortalControlStructures pcs = this.getPortalControlStructuresForChannel(request, response, channelSubscribeId);
        try {
            prvChanObj.setPortalControlStructures(pcs);
        }
        catch (Exception e) {
            prvChanObj = (IPrivileged)((Object)this.replaceWithErrorChannel(request, response, channelSubscribeId, ErrorCode.SET_PCS_EXCEPTION, e, null, false));
            try {
                prvChanObj.setPortalControlStructures(pcs);
            }
            catch (Exception e2) {
                log.error((Object)"Error channel threw exception accepting PortalControlStructures", (Throwable)e2);
            }
        }
        return (IChannel)((Object)prvChanObj);
    }

    public IChannel getChannelInstance(HttpServletRequest request, HttpServletResponse response, String channelSubscribeId) {
        IChannel ch = this.channelTable.get(channelSubscribeId);
        if (ch == null) {
            try {
                ch = this.instantiateChannel(request, response, channelSubscribeId);
            }
            catch (Throwable e) {
                log.warn((Object)e, e);
                return null;
            }
        }
        return ch;
    }

    public void removeChannel(HttpServletRequest request, HttpServletResponse response, String channelSubscribeId) {
        IChannel ch = this.channelTable.get(channelSubscribeId);
        if (ch != null) {
            this.channelCacheTable.remove(ch);
            this.passPortalEvent(request, response, channelSubscribeId, PortalEvent.UNSUBSCRIBE_EVENT);
            this.channelTable.remove(channelSubscribeId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("removed channel with subscribe id=" + channelSubscribeId));
            }
        }
    }

    public void startRenderingCycle(HttpServletRequest request, HttpServletResponse response, UPFileSpec uPElement) {
        this.browserInfo = new BrowserInfo(request);
        this.uPElement = uPElement;
        this.rendererTable.clear();
        this.processRequestChannelParameters(request, response);
    }

    public boolean isCharacterCaching() {
        return this.characterCaching;
    }

    public void setCharacterCaching(boolean setting) {
        this.characterCaching = setting;
    }

    public void setUPElement(UPFileSpec uPElement) {
        this.uPElement = uPElement;
    }

    public boolean doChannelAction(HttpServletRequest request, HttpServletResponse response, String channelSubscribeId, boolean noTimeout) throws PortalException {
        int renderingStatus;
        IChannel ch;
        IUserLayoutNodeDescription node = this.userPreferencesManager.getUserLayoutManager().getNode(channelSubscribeId);
        if (!(node instanceof IUserLayoutChannelDescription)) {
            throw new PortalException("'" + channelSubscribeId + "' is not a channel node !");
        }
        IUserLayoutChannelDescription channel = (IUserLayoutChannelDescription)node;
        long timeOut = channel.getTimeout();
        IChannel originalChannel = ch = this.channelTable.get(channelSubscribeId);
        if (ch == null || ch instanceof CSecureInfo) {
            try {
                ch = this.instantiateChannel(request, response, channel);
            }
            catch (Throwable e) {
                ch = this.replaceWithErrorChannel(request, response, channelSubscribeId, ErrorCode.SET_STATIC_DATA_EXCEPTION, e, null, false);
            }
        }
        if (ch instanceof IPrivileged) {
            ch = this.feedPortalControlStructuresToChannel(request, response, channelSubscribeId, (IPrivileged)((Object)ch));
        }
        if (originalChannel != null && originalChannel != ch) {
            return false;
        }
        ChannelRuntimeData runtimeData = this.getChannelRuntimeData(request, channelSubscribeId, RequestType.ACTION);
        IChannelRenderer channelRenderer = cChannelRendererFactory.newInstance(ch, runtimeData);
        if (noTimeout) {
            channelRenderer.setTimeout(0L);
        } else {
            channelRenderer.setTimeout(timeOut);
        }
        channelRenderer.startRendering();
        try {
            renderingStatus = channelRenderer.completeRendering();
        }
        catch (Throwable t) {
            ch = this.replaceWithErrorChannel(request, response, channelSubscribeId, ErrorCode.RENDER_TIME_EXCEPTION, t, null, false);
            log.error((Object)"Failed to complete action", t);
            return false;
        }
        if (renderingStatus != 0) {
            ErrorCode errorCode = renderingStatus == 2 ? ErrorCode.TIMEOUT_EXCEPTION : ErrorCode.GENERAL_ERROR;
            ch = this.replaceWithErrorChannel(request, response, channelSubscribeId, errorCode, null, "unsuccessful rendering", true);
            log.error((Object)("Action did not compplete successefully: " + renderingStatus));
            return false;
        }
        IUserLayoutChannelDescription channelDesc = null;
        IUserLayoutNodeDescription parentNode = null;
        try {
            IUserLayoutManager userLayoutManager = this.userPreferencesManager.getUserLayoutManager();
            channelDesc = (IUserLayoutChannelDescription)userLayoutManager.getNode(channelSubscribeId);
            String parentNodeId = userLayoutManager.getParentId(channelDesc.getId());
            if (parentNodeId != null) {
                parentNode = userLayoutManager.getNode(parentNodeId);
            }
        }
        catch (PortalException pe) {
            log.warn((Object)("Failed to load IUserLayoutChannelDescription and parent IUserLayoutNodeDescription for channel with subscribe id: " + channelSubscribeId), (Throwable)pe);
        }
        IPerson person = this.userPreferencesManager.getPerson();
        UserProfile userProfile = this.userPreferencesManager.getCurrentProfile();
        long renderTime = channelRenderer.getRenderTime();
        PortletActionInLayoutPortalEvent portletActionEvent = new PortletActionInLayoutPortalEvent((Object)this, person, userProfile, channel, parentNode, renderTime);
        EventPublisherLocator.getApplicationEventPublisher().publishEvent((ApplicationEvent)portletActionEvent);
        return true;
    }

    public IChannelRenderer startChannelRendering(HttpServletRequest request, HttpServletResponse response, String channelSubscribeId) throws PortalException {
        return this.startChannelRendering(request, response, channelSubscribeId, false);
    }

    private IChannelRenderer startChannelRendering(HttpServletRequest request, HttpServletResponse response, String channelSubscribeId, boolean noTimeout) throws PortalException {
        long timeOut = 0L;
        IUserLayoutNodeDescription node = this.userPreferencesManager.getUserLayoutManager().getNode(channelSubscribeId);
        if (!(node instanceof IUserLayoutChannelDescription)) {
            throw new PortalException("'" + channelSubscribeId + "' is not a channel node !");
        }
        IUserLayoutChannelDescription channel = (IUserLayoutChannelDescription)node;
        timeOut = channel.getTimeout();
        IChannel ch = this.channelTable.get(channelSubscribeId);
        if (!request.isSecure() && channel.isSecure()) {
            if (!(ch instanceof CSecureInfo)) {
                ch = this.replaceWithSecureInfoChannel(request, response, channelSubscribeId, false);
            }
        } else if (ch == null || ch instanceof CSecureInfo) {
            try {
                ch = this.instantiateChannel(request, response, channel);
            }
            catch (Throwable e) {
                ch = this.replaceWithErrorChannel(request, response, channelSubscribeId, ErrorCode.SET_STATIC_DATA_EXCEPTION, e, null, false);
            }
        }
        if (ch instanceof IPrivileged) {
            this.feedPortalControlStructuresToChannel(request, response, channelSubscribeId, (IPrivileged)((Object)ch));
        }
        ChannelRuntimeData runtimeData = !channelSubscribeId.equals(this.channelTarget) ? this.getChannelRuntimeData(request, channelSubscribeId, RequestType.RENDER) : this.getChannelRuntimeData(request, this.channelTarget, RequestType.RENDER);
        IChannelRenderer channelRenderer = cChannelRendererFactory.newInstance(ch, runtimeData);
        channelRenderer.setCharacterCacheable(this.characterCaching);
        if (ch instanceof ICacheable) {
            channelRenderer.setCacheTables(this.channelCacheTable);
        }
        if (noTimeout) {
            channelRenderer.setTimeout(0L);
        } else {
            channelRenderer.setTimeout(timeOut);
        }
        if (this.groupedRendering && (this.isListeningToChannels(channelSubscribeId) || channelSubscribeId.equals(this.channelTarget))) {
            this.pendingChannels.add(channelSubscribeId);
        } else {
            channelRenderer.startRendering();
        }
        this.rendererTable.put(channelSubscribeId, channelRenderer);
        return channelRenderer;
    }

    private ChannelRuntimeData getChannelRuntimeData(HttpServletRequest request, String channelSubscribeId, RequestType requestType) {
        ChannelRuntimeData runtimeData = new ChannelRuntimeData();
        if (channelSubscribeId.equals(this.channelTarget) || RequestType.ACTION.equals((Object)requestType)) {
            String queryString;
            if (this.targetParams != null) {
                runtimeData.setParameters(this.targetParams);
            }
            if ((queryString = request.getQueryString()) != null && queryString.indexOf("=") == -1) {
                runtimeData.setKeywords(queryString);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Marking channel " + channelSubscribeId + " as targeted. targetedId=" + this.channelTarget + ", requestType=" + (Object)((Object)requestType)));
            }
            runtimeData.setTargeted(true);
        }
        runtimeData.setBrowserInfo(this.browserInfo);
        if (this.localeManager != null) {
            runtimeData.setLocales(this.localeManager.getLocales());
        }
        runtimeData.setHttpRequestMethod(request.getMethod());
        runtimeData.setRemoteAddress(request.getRemoteAddr());
        UPFileSpec upFile = new UPFileSpec(this.uPElement);
        upFile.setTargetNodeId(channelSubscribeId);
        runtimeData.setUPFile(upFile);
        UserPreferences userPreferences = this.userPreferencesManager.getUserPreferences();
        StructureStylesheetUserPreferences structureStylesheetUserPreferences = userPreferences.getStructureStylesheetUserPreferences();
        String userLayoutRoot = structureStylesheetUserPreferences.getParameterValue("userLayoutRoot");
        if (userLayoutRoot != null && !"root".equals(userLayoutRoot)) {
            runtimeData.setRenderingAsRoot(true);
        }
        runtimeData.setRequestType(requestType);
        return runtimeData;
    }

    synchronized void registerChannelDependency(String listenerChannelSubscribeId, String talkerChannelSubscribeId) {
        Set<String> talkers = this.iccListeners.get(listenerChannelSubscribeId);
        if (talkers == null) {
            talkers = new HashSet<String>();
            this.iccListeners.put(listenerChannelSubscribeId, talkers);
        }
        talkers.add(talkerChannelSubscribeId);
        Set<String> listeners = this.iccTalkers.get(talkerChannelSubscribeId);
        if (listeners == null) {
            listeners = new HashSet<String>();
            this.iccTalkers.put(talkerChannelSubscribeId, listeners);
        }
        listeners.add(listenerChannelSubscribeId);
    }

    private Set<String> getListeningChannels(String talkerChannelSubscribeId) {
        return this.iccTalkers.get(talkerChannelSubscribeId);
    }

    private boolean isListeningToChannels(String listenerChannelSubscribeId) {
        return this.iccListeners.get(listenerChannelSubscribeId) != null;
    }

    private boolean hasListeningChannels(String talkerChannelSubscribeId) {
        return this.iccTalkers.get(talkerChannelSubscribeId) != null;
    }

    synchronized void removeChannelDependency(String listenerChannelSubscribeId, String talkerChannelSubscribeId) {
        Set<String> listeners;
        Set<String> talkers = this.iccListeners.get(listenerChannelSubscribeId);
        if (talkers != null) {
            talkers.remove(talkerChannelSubscribeId);
            if (talkers.isEmpty()) {
                this.iccListeners.remove(listenerChannelSubscribeId);
            }
        }
        if ((listeners = this.iccTalkers.get(talkerChannelSubscribeId)) != null) {
            listeners.remove(listenerChannelSubscribeId);
            if (listeners.isEmpty()) {
                this.iccTalkers.remove(talkerChannelSubscribeId);
            }
        }
    }

    public String getChannelTarget() {
        return this.channelTarget;
    }

    @Override
    public void channelAdded(LayoutEvent ev) {
    }

    @Override
    public void channelUpdated(LayoutEvent ev) {
    }

    @Override
    public void channelMoved(LayoutMoveEvent ev) {
    }

    @Override
    public void channelDeleted(LayoutMoveEvent ev) {
        HttpServletRequest request;
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            request = ((ServletRequestAttributes)requestAttributes).getRequest();
        } else {
            log.warn((Object)("Available RequestAttributes='" + requestAttributes + "' do not implement ServletRequestAttributes"));
            request = null;
        }
        IUserLayoutNodeDescription nodeDescription = ev.getNodeDescription();
        this.removeChannel(request, null, nodeDescription.getId());
    }

    @Override
    public void folderAdded(LayoutEvent ev) {
    }

    @Override
    public void folderUpdated(LayoutEvent ev) {
    }

    @Override
    public void folderMoved(LayoutMoveEvent ev) {
    }

    @Override
    public void folderDeleted(LayoutMoveEvent ev) {
    }

    @Override
    public void layoutLoaded() {
    }

    @Override
    public void layoutSaved() {
    }

    public void setLocaleManager(LocaleManager lm) {
        this.localeManager = lm;
    }

    public String getChannelTitle(String channelSubscribeId) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("ChannelManager getting dynamic title for channel with subscribe id=" + channelSubscribeId));
        }
        IChannelRenderer channelRenderer = this.rendererTable.get(channelSubscribeId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting Title - Retrieved channel renderer " + (channelRenderer != null ? channelRenderer.toString() : null) + " for subscribe id: " + channelSubscribeId));
        }
        String channelTitle = null;
        if (channelRenderer instanceof IDynamicChannelTitleRenderer) {
            IDynamicChannelTitleRenderer channelTitleRenderer = (IDynamicChannelTitleRenderer)((Object)channelRenderer);
            channelTitle = channelTitleRenderer.getChannelTitle();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Dynamic title for channel with subscribe id=" + channelSubscribeId + " is [" + channelTitle + "]."));
            }
        }
        return channelTitle;
    }

    public String getSubscribeId(String fname) throws PortalException {
        IUserLayoutManager ulm = this.userPreferencesManager.getUserLayoutManager();
        return ulm.getSubscribeId(fname);
    }

    public String getSerializerName() {
        return this.serializerName;
    }

    public void setSerializerName(String serializerName) {
        this.serializerName = serializerName;
    }
}

