/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.ChannelRenderer;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.IChannel;
import org.jasig.portal.IChannelRenderer;
import org.jasig.portal.IChannelRendererFactory;
import org.jasig.portal.PortalSessionManager;
import org.jasig.portal.channels.error.CError;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.utils.threading.PriorityThreadFactory;

@Deprecated
public final class ChannelRendererFactoryImpl
implements IChannelRendererFactory {
    public static final String RCS_ID = "@(#) $Header$";
    private static final Log log = LogFactory.getLog(ChannelRendererFactoryImpl.class);
    private ThreadPoolExecutor mThreadPool = null;
    private static ThreadPoolExecutor cErrorThreadPool = null;
    private static ThreadPoolExecutor cSharedThreadPool = null;

    public ChannelRendererFactoryImpl(String keyBase, AtomicLong activeThreads, AtomicLong maxActiveThreads) {
        int initialThreads = 1;
        int maxThreads = 20;
        int threadPriority = 5;
        boolean sharedPool = false;
        try {
            initialThreads = PropertiesManager.getPropertyAsInt(keyBase + ".threadPool_initialThreads");
            maxThreads = PropertiesManager.getPropertyAsInt(keyBase + ".threadPool_maxThreads");
            threadPriority = PropertiesManager.getPropertyAsInt(keyBase + ".threadPool_threadPriority");
            sharedPool = PropertiesManager.getPropertyAsBoolean(keyBase + ".threadPool_shared");
        }
        catch (Exception x) {
            log.error((Object)("ChannelRendererFactoryImpl(" + keyBase + ") failed to find configuration parameters. Constructing with: " + "threadPool_initialThreads = " + initialThreads + " " + "threadPool_maxThreads = " + maxThreads + " " + "threadPool_threadPriority = " + threadPriority + " " + "threadPool_shared = " + sharedPool), (Throwable)x);
        }
        cErrorThreadPool = new ThreadPoolExecutor(20, 20, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new PriorityThreadFactory(threadPriority, "ErrorRendering", PortalSessionManager.getThreadGroup()));
        if (sharedPool) {
            cSharedThreadPool = new ChannelRenderThreadPoolExecutor(activeThreads, maxActiveThreads, initialThreads, maxThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue(), new PriorityThreadFactory(threadPriority, keyBase, PortalSessionManager.getThreadGroup()));
        } else {
            this.mThreadPool = new ChannelRenderThreadPoolExecutor(activeThreads, maxActiveThreads, initialThreads, maxThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue(), new PriorityThreadFactory(threadPriority, keyBase, PortalSessionManager.getThreadGroup()));
        }
    }

    @Override
    public IChannelRenderer newInstance(IChannel channel, ChannelRuntimeData channelRuntimeData) {
        ThreadPoolExecutor threadPoolExecutor = null;
        if (channel instanceof CError) {
            threadPoolExecutor = cErrorThreadPool;
        } else if (cSharedThreadPool != null) {
            int activeCount = cSharedThreadPool.getActiveCount();
            int queueSize = cSharedThreadPool.getQueue().size();
            int largestPoolSize = cSharedThreadPool.getLargestPoolSize();
            int maxPoolSize = cSharedThreadPool.getMaximumPoolSize();
            if (log.isWarnEnabled() && activeCount >= (int)(0.75 * (double)maxPoolSize)) {
                log.warn((Object)String.format("Rendering thread pool is nearly full. activeCount: %d/%d queueSize: %d largestPoolSize: %d", activeCount, maxPoolSize, queueSize, largestPoolSize));
            }
            if (log.isWarnEnabled() && queueSize >= (int)(0.5 * (double)maxPoolSize)) {
                log.warn((Object)String.format("Rendering thread pool queue size is high. activeCount: %d/%d queueSize: %d largestPoolSize: %d", activeCount, maxPoolSize, queueSize, largestPoolSize));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("stp-activeCount: " + activeCount + " stp-completedTaskCount: " + cSharedThreadPool.getCompletedTaskCount() + " stp-corePoolSize: " + cSharedThreadPool.getCorePoolSize() + " stp-queue-size: " + queueSize));
            }
            threadPoolExecutor = cSharedThreadPool;
        } else {
            threadPoolExecutor = this.mThreadPool;
        }
        return new ChannelRenderer(channel, channelRuntimeData, threadPoolExecutor);
    }

    private class ChannelRenderThreadPoolExecutor
    extends ThreadPoolExecutor {
        final AtomicLong activeThreads;
        final AtomicLong maxActiveThreads;

        public ChannelRenderThreadPoolExecutor(AtomicLong activeThreads, AtomicLong maxActiveThreads, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue, ThreadFactory threadFactory) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, (BlockingQueue<Runnable>)workQueue, threadFactory);
            this.activeThreads = activeThreads;
            this.maxActiveThreads = maxActiveThreads;
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            super.beforeExecute(t, r);
            long current = this.activeThreads.incrementAndGet();
            if (current > this.maxActiveThreads.get()) {
                this.maxActiveThreads.set(current);
            }
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            this.activeThreads.decrementAndGet();
        }
    }
}

