/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.AuthorizationException;
import org.jasig.portal.EntityIdentifier;
import org.jasig.portal.ICCRegistry;
import org.jasig.portal.IllegalChannelParameterOverrideException;
import org.jasig.portal.PortalException;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.node.IUserLayoutChannelDescription;
import org.jasig.portal.security.IAuthorizationPrincipal;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.services.AuthorizationService;
import org.springframework.web.context.WebApplicationContext;

@Deprecated
public class ChannelStaticData
extends Hashtable<Object, Object> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ChannelStaticData.class);
    private long m_timeout = Long.MAX_VALUE;
    private Context m_portalContext = null;
    private String m_channelPublishId = null;
    private String m_channelSubscribeId = null;
    private IPerson m_person = null;
    private ICCRegistry iccr = null;
    private IUserLayoutManager ulm;
    private WebApplicationContext webApplicationContext;
    private String serializerName;
    private IUserLayoutChannelDescription layoutChannelDescription = null;

    public ChannelStaticData() {
        this(null, null);
    }

    public ChannelStaticData(Map parameters, IUserLayoutManager ulm) {
        if (parameters != null) {
            this.putAll(parameters);
        }
        this.ulm = ulm;
    }

    public WebApplicationContext getWebApplicationContext() {
        return this.webApplicationContext;
    }

    public void setWebApplicationContext(WebApplicationContext webApplicationContext) {
        this.webApplicationContext = webApplicationContext;
    }

    public IAuthorizationPrincipal getAuthorizationPrincipal() {
        return ChannelStaticData.getAuthorizationPrincipal(this.getPerson());
    }

    public static IAuthorizationPrincipal getAuthorizationPrincipal(IPerson person) {
        EntityIdentifier pid = person.getEntityIdentifier();
        IAuthorizationPrincipal ap = null;
        try {
            ap = AuthorizationService.instance().newPrincipal(pid.getKey(), pid.getType());
        }
        catch (AuthorizationException ae) {
            log.error((Object)("Could not get authorization service: " + ae));
        }
        return ap;
    }

    public String getChannelPublishId() {
        return this.m_channelPublishId;
    }

    public String getChannelSubscribeId() {
        return this.m_channelSubscribeId;
    }

    public Context getJNDIContext() {
        return this.m_portalContext;
    }

    public synchronized String getParameter(String key) {
        return (String)super.get(key);
    }

    public IPerson getPerson() {
        return this.m_person;
    }

    public long getTimeout() {
        return this.m_timeout;
    }

    public void setChannelPublishId(String channelPublishId) {
        this.m_channelPublishId = channelPublishId;
    }

    public void setChannelSubscribeId(String channelSubscribeId) {
        this.m_channelSubscribeId = channelSubscribeId;
    }

    public void setJNDIContext(Context c) {
        this.m_portalContext = c;
    }

    public String setParameter(String key, String value) {
        if (this.ulm == null) {
            return super.put(key, value);
        }
        try {
            if (this.getChannelDescription().canOverrideParameter(key)) {
                return super.put(key, value);
            }
            throw new IllegalChannelParameterOverrideException(key, value);
        }
        catch (PortalException portalException) {
            return super.put(key, value);
        }
    }

    public boolean canSetParameter(String key) throws PortalException {
        if (this.ulm == null) {
            return true;
        }
        return this.getChannelDescription().canOverrideParameter(key);
    }

    private IUserLayoutChannelDescription getChannelDescription() throws PortalException {
        if (this.layoutChannelDescription == null) {
            this.layoutChannelDescription = (IUserLayoutChannelDescription)this.ulm.getNode(this.getChannelSubscribeId());
        }
        return this.layoutChannelDescription;
    }

    public void resetParameter(String key) {
        if (this.ulm == null) {
            super.remove(key);
            return;
        }
        try {
            this.getChannelDescription().resetParameter(key);
            String value = this.getChannelDescription().getParameterValue(key);
            if (value == null) {
                super.remove(key);
            } else {
                super.put(key, value);
            }
        }
        catch (PortalException pe) {
            super.remove(key);
        }
    }

    public void store() throws PortalException {
        if (this.ulm == null) {
            return;
        }
        IUserLayoutChannelDescription cd = this.getChannelDescription();
        for (Map.Entry parm : this.entrySet()) {
            cd.setParameterValue((String)parm.getKey(), (String)parm.getValue());
        }
        this.ulm.updateNode(cd);
        this.ulm.saveUserLayout();
        this.layoutChannelDescription = null;
    }

    public void setParameters(Map params) {
        if (this.ulm == null) {
            this.putAll(params);
        }
        try {
            IUserLayoutChannelDescription cd = this.getChannelDescription();
            for (Map.Entry e : params.entrySet()) {
                if (cd.canOverrideParameter((String)e.getKey())) continue;
                throw new IllegalChannelParameterOverrideException((String)e.getKey(), (String)e.getValue());
            }
        }
        catch (PortalException portalException) {
            // empty catch block
        }
        this.putAll(params);
    }

    public void setPerson(IPerson person) {
        this.m_person = person;
    }

    public void setTimeout(long value) {
        this.m_timeout = value;
    }

    public ICCRegistry getICCRegistry() {
        return this.iccr;
    }

    public void setICCRegistry(ICCRegistry registry) {
        this.iccr = registry;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ChannelStaticData: ");
        sb.append("Channel Publish ID = [").append(this.m_channelPublishId).append("] ");
        sb.append("Channel Subscribe ID = [").append(this.m_channelSubscribeId).append("] ");
        sb.append("person= [").append(this.m_person).append("] ");
        return sb.toString();
    }

    public String getSerializerName() {
        return this.serializerName;
    }

    public void setSerializerName(String serializerName) {
        this.serializerName = serializerName;
    }
}

