/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.CacheEntry;
import org.jasig.portal.ChannelContentCacheEntry;
import org.jasig.portal.ChannelManager;
import org.jasig.portal.PortalException;
import org.jasig.portal.StringCacheEntry;
import org.jasig.portal.serialize.CachingSerializer;
import org.jasig.portal.serialize.MarkupSerializer;
import org.jasig.portal.utils.SAX2FilterImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CharacterCachingChannelIncorporationFilter
extends SAX2FilterImpl {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String insideElement = null;
    ChannelManager cm;
    private String channelSubscribeId = null;
    private String channelTitle = null;
    private String defaultChannelTitle = null;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final boolean ccaching;
    private final CachingSerializer ser;
    private List<CacheEntry> cacheEntries;

    public CharacterCachingChannelIncorporationFilter(ContentHandler handler, ChannelManager chanm, boolean ccaching, HttpServletRequest request, HttpServletResponse response) {
        super(handler);
        if (handler instanceof CachingSerializer) {
            this.ccaching = ccaching;
            this.ser = (CachingSerializer)handler;
            this.cacheEntries = new LinkedList<CacheEntry>();
        } else {
            this.ccaching = false;
            this.ser = null;
            this.cacheEntries = null;
        }
        this.cm = chanm;
        this.request = request;
        this.response = response;
    }

    public List<CacheEntry> getCacheBlocks() {
        if (this.ccaching) {
            return this.cacheEntries;
        }
        return null;
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.ccaching) {
            try {
                if (!this.ser.startCaching()) {
                    this.log.error((Object)"CharacterCachingChannelIncorporationFilter::startDocument() : unable to start caching!");
                }
            }
            catch (IOException ioe) {
                this.log.error((Object)"CharacterCachingChannelIncorporationFilter::startDocument() : unable to start caching!", (Throwable)ioe);
            }
        }
        super.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        if (this.ccaching) {
            try {
                if (this.ser.stopCaching()) {
                    try {
                        this.cacheEntries.add(new StringCacheEntry(this.ser.getCache()));
                    }
                    catch (UnsupportedEncodingException e) {
                        this.log.error((Object)"CharacterCachingChannelIncorporationFilter::endDocument() : unable to obtain character cache, invalid encoding specified ! ", (Throwable)e);
                    }
                    catch (IOException ioe) {
                        this.log.error((Object)"CharacterCachingChannelIncorporationFilter::endDocument() : IO exception occurred while retreiving character cache ! ", (Throwable)ioe);
                    }
                } else {
                    this.log.error((Object)"CharacterCachingChannelIncorporationFilter::endDocument() : unable to stop caching!");
                }
            }
            catch (IOException ioe) {
                this.log.error((Object)"CharacterCachingChannelIncorporationFilter::endDocument() : unable to stop caching!", (Throwable)ioe);
            }
        }
    }

    private void startCaching() {
        try {
            if (!this.ser.startCaching()) {
                this.log.error((Object)"CharacterCachingChannelIncorporationFilter::endElement() : unable to restart cache after a channel end!");
            }
        }
        catch (IOException ioe) {
            this.log.error((Object)"CharacterCachingChannelIncorporationFilter::endElement() : unable to start caching!", (Throwable)ioe);
        }
    }

    private void stopCaching() {
        try {
            if (this.ser.stopCaching()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("CharacterCachingChannelIncorporationFilter::endElement() : obtained the following system character entry: \n" + this.ser.getCache()));
                }
                this.cacheEntries.add(new StringCacheEntry(this.ser.getCache()));
            } else {
                this.log.error((Object)"CharacterCachingChannelIncorporationFilter::startElement() : unable to reset cache state ! Serializer was not caching when it should've been !");
            }
        }
        catch (UnsupportedEncodingException e) {
            this.log.error((Object)"CharacterCachingChannelIncorporationFilter::startElement() : unable to obtain character cache, invalid encoding specified ! ", (Throwable)e);
        }
        catch (IOException ioe) {
            this.log.error((Object)"CharacterCachingChannelIncorporationFilter::startElement() : IO exception occurred while retreiving character cache ! ", (Throwable)ioe);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("CharacterCachingChannelIncorporationFilter is filtering element with uri=" + uri + " localName=" + localName + " qName=" + qName + "atts=" + atts + " .  Current channelSubscribeId=" + this.channelSubscribeId + " and in element " + this.insideElement));
        }
        if (!this.isInIncorporationElement()) {
            if (qName.equals("channel")) {
                this.insideElement = "channel";
                this.channelSubscribeId = atts.getValue("ID");
                if (this.channelSubscribeId == null) {
                    String fname = atts.getValue("fname");
                    if (fname.equals("")) {
                        this.log.error((Object)"Incurred a channel with no subscribe id in attribute 'ID' and no functional name in attribute 'fname'.");
                    } else {
                        try {
                            this.channelSubscribeId = this.cm.getSubscribeId(fname);
                        }
                        catch (PortalException e) {
                            this.log.error((Object)("Unable to obtain subscribe id for channel with functional name '" + fname + "'."), (Throwable)e);
                        }
                    }
                }
                if (this.ccaching) {
                    this.stopCaching();
                }
            } else if (qName.equals("channel-title")) {
                this.insideElement = "channel-title";
                this.channelSubscribeId = atts.getValue("channelSubscribeId");
                this.channelTitle = this.defaultChannelTitle = atts.getValue("defaultValue");
                if (this.ccaching) {
                    this.stopCaching();
                }
            } else {
                super.startElement(uri, localName, qName, atts);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Ignoring element " + qName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("CharacterCachingChannelIncorporationFilter is filtering end element with url=" + uri + " localName=" + localName + " qName=" + qName + " .  Current channelSubscribeId=" + this.channelSubscribeId + " and in element " + this.insideElement));
        }
        if (this.isInIncorporationElement()) {
            if (!qName.equals("channel") || !this.insideElement.equals("channel")) return;
            try {
                ContentHandler contentHandler = this.getContentHandler();
                if (contentHandler != null) {
                    if (this.ccaching) {
                        this.cacheEntries.add(new ChannelContentCacheEntry(this.channelSubscribeId));
                    }
                    this.flush();
                    this.cm.outputChannel(this.request, this.response, this.channelSubscribeId, contentHandler);
                    this.flush();
                    if (!this.ccaching) return;
                    this.startCaching();
                    return;
                }
                this.log.error((Object)("null ContentHandler prevents outputting channel with subscribe id = " + this.channelSubscribeId));
                return;
            }
            finally {
                this.endIncorporationElement();
            }
        } else {
            super.endElement(uri, localName, qName);
        }
    }

    public void flush() {
        ContentHandler contentHandler = this.getContentHandler();
        if (contentHandler instanceof MarkupSerializer) {
            try {
                ((MarkupSerializer)contentHandler).flush();
            }
            catch (IOException e) {
                this.logger.warn((Object)"IOException while flushing serializer output", (Throwable)e);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass());
        sb.append(" caching: ").append(this.ccaching);
        sb.append(" currently processing: subscribeId=").append(this.channelSubscribeId);
        sb.append(" in incorporation element: ").append(this.insideElement);
        return sb.toString();
    }

    private boolean isInIncorporationElement() {
        return this.insideElement != null;
    }

    private void endIncorporationElement() {
        if (this.channelSubscribeId == null || this.insideElement == null) {
            throw new IllegalStateException("Cannot end element when not in element:" + this);
        }
        this.channelSubscribeId = null;
        this.insideElement = null;
    }
}

