/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.PortalException;
import org.jasig.portal.UPFileSpec;
import org.jasig.portal.portlets.swapper.IdentitySwapperPrincipal;
import org.jasig.portal.portlets.swapper.IdentitySwapperSecurityContext;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.security.PersonManagerFactory;
import org.jasig.portal.services.Authentication;
import org.jasig.portal.utils.CommonUtils;
import org.jasig.portal.utils.ResourceLoader;

public class LoginServlet
extends HttpServlet {
    public static final String SWAP_TARGET_UID = LoginServlet.class.getName() + ".SWAP_TARGET_UID";
    public static final String SWAP_ORIGINAL_UID = LoginServlet.class.getName() + ".SWAP_ORIGINAL_UID";
    private static final Log log = LogFactory.getLog(LoginServlet.class);
    private static final Log swapperLog = LogFactory.getLog((String)"org.jasig.portal.portlets.swapper");
    private static final String redirectString;
    private static HashMap credentialTokens;
    private static HashMap principalTokens;
    protected Authentication m_authenticationService = null;

    public void init() throws ServletException {
        this.m_authenticationService = new Authentication();
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        IPerson person;
        HttpSession s;
        boolean swap;
        String originalUid;
        String targetUid;
        IPersonManager personManager;
        block24: {
            CommonUtils.setNoCache(response);
            try {
                request.setCharacterEncoding("UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                log.error((Object)"Unable to set UTF-8 character encoding!", (Throwable)uee);
            }
            personManager = PersonManagerFactory.getPersonManagerInstance();
            targetUid = null;
            originalUid = null;
            swap = false;
            if (request.isRequestedSessionIdValid()) {
                try {
                    s = request.getSession(false);
                    originalUid = (String)s.getAttribute(SWAP_ORIGINAL_UID);
                    if (originalUid == null) {
                        targetUid = (String)s.getAttribute(SWAP_TARGET_UID);
                        if (targetUid != null) {
                            person = personManager.getPerson(request);
                            originalUid = person.getName();
                            swap = true;
                        }
                    } else {
                        person = personManager.getPerson(request);
                        targetUid = person.getName();
                    }
                    s.invalidate();
                }
                catch (IllegalStateException ise) {
                    if (!log.isTraceEnabled()) break block24;
                    log.trace((Object)"LoginServlet attempted to invalidate an already invalid session.", (Throwable)ise);
                }
            }
        }
        s = request.getSession(true);
        person = null;
        try {
            HashMap credentials;
            HashMap principals;
            person = personManager.getPerson(request);
            if (targetUid != null && originalUid != null) {
                if (swap) {
                    swapperLog.warn((Object)("Swapping identity for '" + originalUid + "' to '" + targetUid + "'"));
                    s.setAttribute(SWAP_ORIGINAL_UID, (Object)originalUid);
                    person.setUserName(targetUid);
                } else {
                    swapperLog.warn((Object)("Reverting swapped identity from '" + targetUid + "' to '" + originalUid + "'"));
                    person.setUserName(originalUid);
                }
                IdentitySwapperPrincipal identitySwapperPrincipal = new IdentitySwapperPrincipal(person);
                IdentitySwapperSecurityContext identitySwapperSecurityContext = new IdentitySwapperSecurityContext(identitySwapperPrincipal);
                person.setSecurityContext(identitySwapperSecurityContext);
                principals = new HashMap();
                credentials = new HashMap();
            } else {
                principals = this.getPropertyFromRequest(principalTokens, request);
                credentials = this.getPropertyFromRequest(credentialTokens, request);
            }
            this.m_authenticationService.authenticate(principals, credentials, person);
        }
        catch (Exception e) {
            log.error((Object)"Exception authenticating the request", (Throwable)e);
            request.getSession(false).invalidate();
            request.getSession(true).setAttribute("up_authenticationError", (Object)"true");
            person = null;
        }
        String redirectTarget = null;
        String refUrl = request.getParameter("refUrl");
        if (refUrl != null) {
            if (refUrl.startsWith("/")) {
                redirectTarget = refUrl;
            } else {
                log.warn((Object)("Refernce URL passed in does not start with a / and will be ignored: " + refUrl));
            }
        }
        if (redirectTarget == null) {
            String targetFname = request.getParameter("uP_fname");
            if (targetFname == null) {
                redirectTarget = request.getContextPath() + "/" + redirectString;
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append(request.getContextPath());
                sb.append("/tag.idempotent.");
                sb.append(redirectString);
                sb.append("?uP_fname=");
                sb.append(URLEncoder.encode(targetFname, "UTF-8"));
                Enumeration e = request.getParameterNames();
                while (e.hasMoreElements()) {
                    String paramName = (String)e.nextElement();
                    if (paramName.equals("uP_fname")) continue;
                    sb.append('&');
                    sb.append(paramName);
                    sb.append('=');
                    sb.append(URLEncoder.encode(request.getParameter(paramName), "UTF-8"));
                }
                redirectTarget = sb.toString();
            }
        }
        if (person == null || !person.getSecurityContext().isAuthenticated()) {
            String attemptedUserName;
            if (request.getMethod().equals("POST")) {
                request.getSession(false).setAttribute("up_authenticationAttempted", (Object)"true");
            }
            if ((attemptedUserName = request.getParameter("userName")) != null) {
                request.getSession(false).setAttribute("up_attemptedUserName", (Object)request.getParameter("userName"));
            }
        }
        String encodedRedirectURL = response.encodeRedirectURL(redirectTarget);
        response.sendRedirect(encodedRedirectURL);
    }

    private HashMap getPropertyFromRequest(HashMap tokens, HttpServletRequest request) {
        HashMap<String, String> retHash = new HashMap<String, String>(1);
        for (String ctxName : tokens.keySet()) {
            String parmName = (String)tokens.get(ctxName);
            String parmValue = null;
            if (request.getAttribute(parmName) != null) {
                try {
                    parmValue = (String)request.getAttribute(parmName);
                }
                catch (ClassCastException cce) {
                    String msg = "The request attribute '" + parmName + "' must be a String.";
                    throw new RuntimeException(msg, cce);
                }
            } else {
                parmValue = request.getParameter(parmName);
            }
            parmValue = "password".equals(parmName) ? (parmValue == null ? "" : parmValue) : (parmValue == null ? "" : parmValue).trim();
            String key = ctxName.startsWith("root.") ? ctxName.substring(5) : ctxName;
            retHash.put(key, parmValue);
        }
        return retHash;
    }

    static {
        String upFile = "render.userLayoutRootNode.uP";
        HashMap<String, String> cHash = new HashMap<String, String>(1);
        HashMap<String, String> pHash = new HashMap<String, String>(1);
        try {
            upFile = UPFileSpec.buildUPFile(0, "userLayoutRootNode", null, null);
            Properties props = ResourceLoader.getResourceAsProperties(LoginServlet.class, "/properties/security.properties");
            Enumeration<?> propNames = props.propertyNames();
            while (propNames.hasMoreElements()) {
                String key;
                String propName = (String)propNames.nextElement();
                String propValue = props.getProperty(propName);
                if (propName.startsWith("credentialToken.")) {
                    key = propName.substring(16);
                    cHash.put(key, propValue);
                }
                if (!propName.startsWith("principalToken.")) continue;
                key = propName.substring(15);
                pHash.put(key, propValue);
            }
        }
        catch (PortalException pe) {
            log.error((Object)"LoginServlet::static ", (Throwable)pe);
        }
        catch (IOException ioe) {
            log.error((Object)"LoginServlet::static ", (Throwable)ioe);
        }
        redirectString = upFile;
        credentialTokens = cHash;
        principalTokens = pHash;
    }
}

