/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.multipart.MultipartFile;

@Deprecated
public class MultipartDataSource
implements DataSource {
    private static final Log log = LogFactory.getLog(MultipartDataSource.class);
    File tempfile;
    ByteArrayOutputStream buff = null;
    String contentType = null;
    String filename = null;
    String errorMessage = null;
    boolean isAvailable = false;

    public MultipartDataSource(MultipartFile multipartFile) {
        this.contentType = multipartFile.getContentType();
        this.filename = multipartFile.getOriginalFilename();
        try {
            this.tempfile = File.createTempFile("uPdata", null);
            this.tempfile.deleteOnExit();
            multipartFile.transferTo(this.tempfile);
        }
        catch (IOException ioe) {
            log.error((Object)"MultipartDataSource unable to create temp file", (Throwable)ioe);
            if (this.tempfile != null) {
                try {
                    this.tempfile.delete();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.tempfile = null;
            }
            this.buff = new ByteArrayOutputStream();
            try {
                this.buff.write(multipartFile.getBytes());
            }
            catch (IOException ioe2) {
                log.error((Object)"MultipartDataSource unable to store data in ByteArrayOutputStream", (Throwable)ioe2);
            }
        }
        this.isAvailable = true;
    }

    public MultipartDataSource(String fileName, String errorMessage) {
        this.filename = fileName;
        this.errorMessage = errorMessage;
        this.isAvailable = false;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public void dispose() {
        this.buff = null;
        if (this.tempfile != null) {
            boolean success = this.tempfile.delete();
            if (!success) {
                log.error((Object)("Unable to delete temp file [" + this.tempfile.getPath() + "]"));
            }
            this.tempfile = null;
        }
    }

    public InputStream getInputStream() throws IOException {
        if (!this.isAvailable()) {
            throw new IOException(this.getErrorMessage());
        }
        if (this.tempfile != null) {
            return new BufferedInputStream(new FileInputStream(this.tempfile));
        }
        return new ByteArrayInputStream(this.buff.toByteArray());
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("getOutputStream() not implemented");
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getName() {
        return this.filename;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

