/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Random;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.ErrorID;
import org.jasig.portal.Errors;
import org.jasig.portal.ExceptionHelper;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.rendering.IPortalRenderingPipeline;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.IPersonManager;
import org.jasig.portal.spring.locator.PersonManagerLocator;
import org.jasig.portal.spring.locator.PortalRenderingPipelineLocator;
import org.jasig.portal.spring.locator.RequestParameterProcessorControllerLocator;
import org.jasig.portal.spring.locator.UserInstanceManagerLocator;
import org.jasig.portal.tools.versioning.Version;
import org.jasig.portal.tools.versioning.VersionsManager;
import org.jasig.portal.url.IWritableHttpServletRequest;
import org.jasig.portal.url.PortalHttpServletRequestWrapper;
import org.jasig.portal.url.PortalHttpServletResponseWrapper;
import org.jasig.portal.url.processing.IRequestParameterProcessorController;
import org.jasig.portal.user.IUserInstance;
import org.jasig.portal.user.IUserInstanceManager;
import org.jasig.portal.utils.ResourceLoader;

public class PortalSessionManager
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(PortalSessionManager.class);
    private static final boolean DEFAULT_URL_CACHING = true;
    private static final String DEFAULT_SAX_DRIVER = "org.apache.xerces.parsers.SAXParser";
    private static boolean initialized = false;
    private static ServletContext servletContext = null;
    private static PortalSessionManager instance = null;
    private static boolean fatalError = false;
    private static int unauthenticatedUserSessionTimeout = 0;
    public static final ErrorID initPortalContext = new ErrorID("config", "JNDI", "Cannot initialize JNDI context");
    private static final ThreadGroup threadGroup = new ThreadGroup("uPortal");
    private static final Random randomGenerator = new Random();
    public static Date STARTED_AT = new Date(0L);

    public static ThreadGroup getThreadGroup() {
        return threadGroup;
    }

    public static final PortalSessionManager getInstance() {
        return instance;
    }

    public void init() throws ServletException {
        if (!initialized) {
            block7: {
                STARTED_AT = new Date();
                instance = this;
                ServletConfig sc = this.getServletConfig();
                if (sc == null) {
                    throw new ServletException("PortalSessionManager.init(): ServletConfig object was returned as null");
                }
                servletContext = sc.getServletContext();
                if (!PropertiesManager.getPropertyAsBoolean("org.jasig.portal.PortalSessionManager.url_caching", true)) {
                    try {
                        URL url = ResourceLoader.getResourceAsURL(PortalSessionManager.class, "/properties/portal.properties");
                        URLConnection conn = url.openConnection();
                        conn.setDefaultUseCaches(false);
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) break block7;
                        log.warn((Object)"PortalSessionManager.init(): Caught Exception trying to disable URL Caching", (Throwable)e);
                    }
                }
            }
            if (System.getProperty("org.xml.sax.driver") == null) {
                System.setProperty("org.xml.sax.driver", PropertiesManager.getProperty("org.xml.sax.driver", DEFAULT_SAX_DRIVER));
            }
            if ((unauthenticatedUserSessionTimeout = PropertiesManager.getPropertyAsInt(PortalSessionManager.class.getName() + ".unauthenticatedUserSessionTimeout", 0)) < -1) {
                unauthenticatedUserSessionTimeout = -1;
            }
            initialized = true;
            log.info((Object)"uPortal started");
        }
    }

    public void destroy() {
        log.info((Object)"uPortal stopped");
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) {
        this.doGet(req, res);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse res) {
        try {
            request.setCharacterEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            log.error((Object)"Unable to set UTF-8 character encoding!", (Throwable)uee);
        }
        IUserInstanceManager userInstanceManager = UserInstanceManagerLocator.getUserInstanceManager();
        res = new PortalHttpServletResponseWrapper((HttpServletResponse)res);
        PortalHttpServletRequestWrapper writableRequest = new PortalHttpServletRequestWrapper(request, (HttpServletResponse)res, userInstanceManager);
        this.doGetInternal(writableRequest, (HttpServletResponse)res);
    }

    protected void doGetInternal(IWritableHttpServletRequest writableRequest, HttpServletResponse res) {
        VersionsManager versionManager = VersionsManager.getInstance();
        Version version = versionManager.getVersion("UP_FRAMEWORK");
        res.setHeader("uPortal-version", "uPortal_rel-" + version.getMajor() + "-" + version.getMinor() + "-" + version.getMicro());
        if (fatalError) {
            try {
                StringBuilder loginRedirect = new StringBuilder();
                loginRedirect.append(writableRequest.getContextPath());
                loginRedirect.append("/Login?refUrl=");
                String requestEncoding = writableRequest.getCharacterEncoding();
                loginRedirect.append(URLEncoder.encode(writableRequest.getRequestURI(), requestEncoding));
                String queryString = writableRequest.getQueryString();
                if (queryString != null) {
                    loginRedirect.append(URLEncoder.encode("?", requestEncoding));
                    loginRedirect.append(URLEncoder.encode(queryString, requestEncoding));
                }
                String encodedRedirectURL = res.encodeRedirectURL(loginRedirect.toString());
                res.sendRedirect(encodedRedirectURL);
            }
            catch (IOException e) {
                ExceptionHelper.genericTopHandler(Errors.bug, e);
            }
            return;
        }
        HttpSession session = writableRequest.getSession(false);
        if (session == null) {
            try {
                StringBuilder loginRedirect = new StringBuilder();
                loginRedirect.append(writableRequest.getContextPath());
                loginRedirect.append("/Login?refUrl=");
                String requestEncoding = writableRequest.getCharacterEncoding();
                loginRedirect.append(URLEncoder.encode(writableRequest.getRequestURI(), requestEncoding));
                String queryString = writableRequest.getQueryString();
                if (queryString != null) {
                    loginRedirect.append(URLEncoder.encode("?", requestEncoding));
                    loginRedirect.append(URLEncoder.encode(queryString, requestEncoding));
                }
                String encodedRedirectURL = res.encodeRedirectURL(loginRedirect.toString());
                res.sendRedirect(encodedRedirectURL);
            }
            catch (Exception e) {
                ExceptionHelper.genericTopHandler(Errors.bug, e);
                ExceptionHelper.generateErrorPage(res, e);
            }
            return;
        }
        IPersonManager personManager = PersonManagerLocator.getPersonManager();
        IPerson person = personManager.getPerson(writableRequest);
        if (person != null && !person.getSecurityContext().isAuthenticated() && unauthenticatedUserSessionTimeout != 0) {
            session.setMaxInactiveInterval(unauthenticatedUserSessionTimeout);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unauthenticated user session timeout set to: " + unauthenticatedUserSessionTimeout));
            }
        }
        try {
            IRequestParameterProcessorController requestProcessorController = RequestParameterProcessorControllerLocator.getRequestParameterProcessorController();
            requestProcessorController.processParameters(writableRequest, res);
            IUserInstanceManager userInstanceManager = UserInstanceManagerLocator.getUserInstanceManager();
            IUserInstance userInstance = userInstanceManager.getUserInstance(writableRequest);
            IPortalRenderingPipeline portalRenderingPipeline = PortalRenderingPipelineLocator.getPortalRenderingPipeline();
            portalRenderingPipeline.renderState(writableRequest, res, userInstance);
        }
        catch (Exception e) {
            ExceptionHelper.genericTopHandler(Errors.bug, e);
            ExceptionHelper.generateErrorPage(res, e);
            return;
        }
    }

    public static URL getResourceAsURL(String resource) {
        if (!resource.startsWith("/")) {
            resource = "/" + resource;
        }
        URL url = null;
        try {
            url = servletContext.getResource(resource);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return url;
    }

    public static InputStream getResourceAsStream(String resource) {
        if (!resource.startsWith("/")) {
            resource = "/" + resource;
        }
        if (servletContext != null) {
            return servletContext.getResourceAsStream(resource);
        }
        throw new IllegalStateException("Unable to load resource '" + resource + "' because the servlet context has not been initialized yet");
    }

    public static boolean isServletContext() {
        return servletContext != null;
    }

    public boolean getFatalError() {
        return fatalError;
    }

    public Random getRandom() {
        return randomGenerator;
    }
}

