/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.ISequenceGenerator;
import org.jasig.portal.RDBMServices;

@Deprecated
public class ReferenceSequenceGenerator
implements ISequenceGenerator {
    private static final Log log = LogFactory.getLog(ReferenceSequenceGenerator.class);
    private Random rand = new Random();
    private static String SEQUENCE_TABLE = "UP_SEQUENCE";
    private static String NAME_COLUMN = "SEQUENCE_NAME";
    private static String VALUE_COLUMN = "SEQUENCE_VALUE";
    private static int INITIAL_COUNTER_VALUE = 0;
    private static int NO_COUNTER_VALUE = -1;
    private static String QUOTE = "'";
    private static String EQ = " = ";
    private static String DEFAULT_COUNTER_NAME = "DEFAULT";
    private static String selectCounterSql;
    private static String updateCounterSql;
    private static String updateCounterForIncrementSql;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void createCounter(String tableName) throws SQLException {
        Connection conn = null;
        try {
            conn = RDBMServices.getConnection();
            this.createCounter(tableName, conn);
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
    }

    private void createCounter(String tableName, Connection conn) throws SQLException {
        Statement stmt = null;
        try {
            int rc;
            stmt = conn.createStatement();
            String sql = this.getCreateCounterSql(tableName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("ReferenceSequenceGenerator.createCounter: " + sql));
            }
            if ((rc = stmt.executeUpdate(this.getCreateCounterSql(tableName))) != 1) {
                throw new DataIntegrityException("Data integrity error; could not update counter.");
            }
        }
        catch (SQLException sqle) {
            log.error((Object)"ReferenceSequenceGenerator::createCounter()", (Throwable)sqle);
            throw sqle;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private String getCreateCounterSql(String table) {
        StringBuffer buff = new StringBuffer(100);
        buff.append("INSERT INTO ");
        buff.append(SEQUENCE_TABLE);
        buff.append(" (");
        buff.append(NAME_COLUMN);
        buff.append(", ");
        buff.append(VALUE_COLUMN);
        buff.append(") VALUES (");
        buff.append(ReferenceSequenceGenerator.sqlQuote(table));
        buff.append(", ");
        buff.append(INITIAL_COUNTER_VALUE);
        buff.append(")");
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCurrentCounterValue(String tableName, Connection conn) throws SQLException {
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            int n;
            block9: {
                ps = conn.prepareStatement(this.getSelectCounterSql());
                try {
                    int currentInt;
                    ps.setString(1, tableName);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("ReferenceSequenceGenerator.getNextInt(): " + ps + " (" + tableName + ")"));
                    }
                    n = currentInt = (rs = ps.executeQuery()).next() ? rs.getInt(VALUE_COLUMN) : NO_COUNTER_VALUE;
                    if (rs == null) break block9;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        rs.close();
                    }
                    throw throwable;
                }
                rs.close();
            }
            return n;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    @Override
    public String getNext() throws Exception {
        return this.getNext(DEFAULT_COUNTER_NAME);
    }

    @Override
    public String getNext(String table) throws Exception {
        return this.getNextInt(table) + "";
    }

    @Override
    public int getNextInt() throws Exception {
        return this.getNextInt(DEFAULT_COUNTER_NAME);
    }

    @Override
    public synchronized int getNextInt(String tableName) throws Exception {
        Connection conn = null;
        try {
            conn = RDBMServices.getConnection();
            int current = this.getCurrentCounterValue(tableName, conn);
            if (current == NO_COUNTER_VALUE) {
                this.createCounter(tableName, conn);
                current = INITIAL_COUNTER_VALUE;
            }
            int n = this.incrementCounter(tableName, current, conn);
            return n;
        }
        catch (SQLException sqle) {
            log.error((Object)"ReferenceSequenceGenerator.getNextInt()", (Throwable)sqle);
            throw sqle;
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
    }

    private String getSelectCounterSql() {
        if (selectCounterSql == null) {
            selectCounterSql = "SELECT " + VALUE_COLUMN + " FROM " + SEQUENCE_TABLE + " WHERE " + NAME_COLUMN + EQ + "?";
        }
        return selectCounterSql;
    }

    private String getUpdateCounterForIncrementSql() {
        if (updateCounterForIncrementSql == null) {
            updateCounterForIncrementSql = "UPDATE " + SEQUENCE_TABLE + " SET " + VALUE_COLUMN + EQ + " ? " + " WHERE " + NAME_COLUMN + EQ + "? AND " + VALUE_COLUMN + EQ + "?";
        }
        return updateCounterForIncrementSql;
    }

    private String getUpdateCounterSql() {
        if (updateCounterSql == null) {
            updateCounterSql = "UPDATE " + SEQUENCE_TABLE + " SET " + VALUE_COLUMN + EQ + " ? " + " WHERE " + NAME_COLUMN + EQ + "?";
        }
        return updateCounterSql;
    }

    private int incrementCounter(String tableName, int currentCounterValue, Connection conn) throws Exception {
        int current = currentCounterValue;
        boolean incremented = false;
        for (int i = 0; i < 20 && !incremented; ++i) {
            try {
                this.primIncrementCounter(tableName, current, conn);
                incremented = true;
                continue;
            }
            catch (DataIntegrityException die) {
                Thread.sleep(this.rand.nextInt(2000));
                current = this.getCurrentCounterValue(tableName, conn);
            }
        }
        if (incremented) {
            return ++current;
        }
        throw new DataIntegrityException("Could not increment counter.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void primIncrementCounter(String tableName, int currentCounterValue, Connection conn) throws SQLException {
        PreparedStatement ps = null;
        int nextCounterValue = currentCounterValue + 1;
        try {
            ps = conn.prepareStatement(this.getUpdateCounterForIncrementSql());
            try {
                int rc;
                ps.setInt(1, nextCounterValue);
                ps.setString(2, tableName);
                ps.setInt(3, currentCounterValue);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ReferenceSequenceGenerator.primIncrementCounter(): " + ps + "(" + nextCounterValue + ", " + tableName + ", " + currentCounterValue + ")"));
                }
                if ((rc = ps.executeUpdate()) != 1) {
                    throw new DataIntegrityException("Data integrity error; could not update counter: " + tableName + " currentCounterValue:" + currentCounterValue);
                }
            }
            catch (SQLException sqle) {
                log.error((Object)sqle.getMessage(), (Throwable)sqle);
                throw sqle;
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    @Override
    public synchronized void setCounter(String tableName, int newCounterValue) throws Exception {
        Connection conn = null;
        try {
            conn = RDBMServices.getConnection();
            this.setCounter(tableName, newCounterValue, conn);
        }
        catch (SQLException sqle) {
            log.error((Object)"ReferenceSequenceGenerator::setCounter()", (Throwable)sqle);
            throw sqle;
        }
        finally {
            RDBMServices.releaseConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCounter(String tableName, int newCounterValue, Connection conn) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(this.getUpdateCounterSql());
            try {
                int rc;
                ps.setInt(1, newCounterValue);
                ps.setString(2, tableName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ReferenceSequenceGenerator.setCounter(): " + ps + "(" + newCounterValue + ", " + tableName + ")"));
                }
                if ((rc = ps.executeUpdate()) != 1) {
                    throw new SQLException("Data integrity error; could not update counter.");
                }
            }
            catch (SQLException sqle) {
                log.error((Object)("Error setting counter for table [" + tableName + "] " + "to " + newCounterValue), (Throwable)sqle);
                throw sqle;
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    private static String sqlQuote(Object o) {
        return QUOTE + o + QUOTE;
    }

    private class DataIntegrityException
    extends SQLException {
        DataIntegrityException(String msg) {
            super(msg);
        }
    }
}

