/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.StylesheetUserPreferences;

public class ThemeStylesheetUserPreferences
extends StylesheetUserPreferences {
    private static final Log log = LogFactory.getLog(ThemeStylesheetUserPreferences.class);
    protected Hashtable channelAttributeNumbers;
    protected Hashtable channelAttributeValues;
    protected ArrayList defaultChannelAttributeValues;

    public ThemeStylesheetUserPreferences() {
        this.channelAttributeNumbers = new Hashtable();
        this.channelAttributeValues = new Hashtable();
        this.defaultChannelAttributeValues = new ArrayList();
    }

    public ThemeStylesheetUserPreferences(ThemeStylesheetUserPreferences ssup) {
        super(ssup);
        this.channelAttributeNumbers = new Hashtable(ssup.channelAttributeNumbers);
        this.channelAttributeValues = new Hashtable(ssup.channelAttributeValues);
        this.defaultChannelAttributeValues = new ArrayList(ssup.defaultChannelAttributeValues);
    }

    @Override
    public Object newInstance() {
        return new ThemeStylesheetUserPreferences(this);
    }

    public String getChannelAttributeValue(String channelSubscribeId, String attributeName) {
        Integer attributeNumber = (Integer)this.channelAttributeNumbers.get(attributeName);
        if (attributeNumber == null) {
            log.error((Object)("ThemeStylesheetUserPreferences::getChannelAttributeValue() : Attempting to obtain a non-existing attribute \"" + attributeName + "\"."));
            return null;
        }
        String value = null;
        List l = (List)this.channelAttributeValues.get(channelSubscribeId);
        if (l == null) {
            return (String)this.defaultChannelAttributeValues.get(attributeNumber);
        }
        if (attributeNumber < l.size()) {
            value = (String)l.get(attributeNumber);
        }
        if (value == null) {
            try {
                value = (String)this.defaultChannelAttributeValues.get(attributeNumber);
            }
            catch (IndexOutOfBoundsException e) {
                log.error((Object)"ThemeStylesheetUserPreferences::getChannelAttributeValue() : internal error - attribute name is registered, but no default value is provided.");
                return null;
            }
        }
        return value;
    }

    public String getDefinedChannelAttributeValue(String channelSubscribeId, String attributeName) {
        Integer attributeNumber = (Integer)this.channelAttributeNumbers.get(attributeName);
        if (attributeNumber == null) {
            log.error((Object)("ThemeStylesheetUserPreferences::hasDefinedChannelAttributeValue() : Attempting to obtain a non-existing attribute \"" + attributeName + "\"."));
            return null;
        }
        List l = (List)this.channelAttributeValues.get(channelSubscribeId);
        if (l == null) {
            return null;
        }
        if (attributeNumber < l.size()) {
            return (String)l.get(attributeNumber);
        }
        return null;
    }

    public void setChannelAttributeValue(String channelSubscribeId, String attributeName, String attributeValue) {
        Integer attributeNumber = (Integer)this.channelAttributeNumbers.get(attributeName);
        if (attributeNumber == null) {
            log.error((Object)("ThemeStylesheetUserPreferences::setChannelAttribute() : Attempting to set a non-existing channel attribute \"" + attributeName + "\"."));
            return;
        }
        List l = (List)this.channelAttributeValues.get(channelSubscribeId);
        if (l == null) {
            l = this.createChannel(channelSubscribeId);
        }
        try {
            l.set(attributeNumber, attributeValue);
        }
        catch (IndexOutOfBoundsException e) {
            for (int i = l.size(); i < attributeNumber; ++i) {
                l.add(null);
            }
            l.add(attributeValue);
        }
    }

    public void addChannelAttribute(String attributeName, String defaultValue) {
        if (this.channelAttributeNumbers.get(attributeName) != null) {
            log.error((Object)("ThemeStylesheetUserPreferences::addChannelAttribute() : Attempting to re-add an existing channel attribute \"" + attributeName + "\"."));
        } else {
            this.channelAttributeNumbers.put(attributeName, new Integer(this.defaultChannelAttributeValues.size()));
            this.defaultChannelAttributeValues.add(defaultValue);
        }
    }

    public void setChannelAttributeDefaultValue(String attributeName, String defaultValue) {
        Integer attributeNumber = (Integer)this.channelAttributeNumbers.get(attributeName);
        this.defaultChannelAttributeValues.set(attributeNumber, defaultValue);
    }

    public void removeChannelAttribute(String attributeName) {
        Integer attributeNumber = (Integer)this.channelAttributeNumbers.get(attributeName);
        if (attributeNumber == null) {
            log.error((Object)("ThemeStylesheetUserPreferences::removeChannelAttribute() : Attempting to remove a non-existing channel attribute \"" + attributeName + "\"."));
        } else {
            this.channelAttributeNumbers.remove(attributeName);
        }
    }

    public Enumeration getChannelAttributeNames() {
        return this.channelAttributeNumbers.keys();
    }

    public void addChannel(String channelSubscribeId) {
        ArrayList l = new ArrayList(this.defaultChannelAttributeValues.size());
        if (this.channelAttributeValues.put(channelSubscribeId, l) != null && log.isDebugEnabled()) {
            log.debug((Object)("ThemeStylesheetUserPreferences::addChannel() : Readding an existing channel (channelSubscribeId=\"" + channelSubscribeId + "\"). All values will be set to default."));
        }
    }

    public void removeChannel(String channelSubscribeId) {
        if (this.channelAttributeValues.remove(channelSubscribeId) == null && log.isDebugEnabled()) {
            log.error((Object)("ThemeStylesheetUserPreferences::removeChannel() : Attempting to remove an non-existing channel (channelSubscribeId=\"" + channelSubscribeId + "\")."));
        }
    }

    public Enumeration getChannels() {
        return this.channelAttributeValues.keys();
    }

    public boolean hasChannel(String channelSubscribeId) {
        return this.channelAttributeValues.containsKey(channelSubscribeId);
    }

    private ArrayList createChannel(String channelSubscribeId) {
        ArrayList l = new ArrayList(this.defaultChannelAttributeValues.size());
        this.channelAttributeValues.put(channelSubscribeId, l);
        return l;
    }

    @Override
    public String getCacheKey() {
        StringBuffer sbKey = new StringBuffer();
        Enumeration e = this.channelAttributeValues.keys();
        while (e.hasMoreElements()) {
            String channelId = (String)e.nextElement();
            sbKey.append("(channel:").append(channelId).append(':');
            List l = (List)this.channelAttributeValues.get(channelId);
            for (int i = 0; i < l.size(); ++i) {
                String value = (String)l.get(i);
                if (value == null) {
                    value = (String)this.defaultChannelAttributeValues.get(i);
                }
                sbKey.append(value).append(",");
            }
            sbKey.append(")");
        }
        return super.getCacheKey().concat(sbKey.toString());
    }
}

