/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.car;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.car.ParsingContext;
import org.jasig.portal.car.RoutingHandler;
import org.jasig.portal.tools.versioning.Version;
import org.jasig.portal.tools.versioning.VersionsManager;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ProcessIfTagHandler
extends DefaultHandler {
    private static final Log log = LogFactory.getLog(ProcessIfTagHandler.class);
    private boolean enabled = false;
    private RoutingHandler routingHandler = null;
    private ParsingContext ctx = null;
    private static final String LESS_THAN = "lessThan";
    private static final String GTR_THAN = "greaterThan";
    private static final String LESS_THAN_OR_EQU = "lessThanOrEqual";
    private static final String GTR_THAN_OR_EQU = "greaterThanOrEqual";
    private static final String EQU = "equalTo";
    private static final String NOT_EQU = "notEqualTo";

    ProcessIfTagHandler(ParsingContext ctx, RoutingHandler routingHandler) {
        this.routingHandler = routingHandler;
        this.ctx = ctx;
    }

    void setAttributes(Attributes atts) {
        this.enabled = false;
        int major = -1;
        int minor = -1;
        int micro = -1;
        int setMajor = -1;
        int setMinor = -1;
        int setMicro = -1;
        String setDescription = null;
        try {
            major = Integer.parseInt(atts.getValue("major"));
            minor = Integer.parseInt(atts.getValue("minor"));
            micro = Integer.parseInt(atts.getValue("micro"));
            if (major < 0 || minor < 0 || micro < 0) {
                throw new IllegalArgumentException();
            }
        }
        catch (Exception e) {
            log.error((Object)("The deployment descriptor META-INF/comp.xml in " + this.ctx.getJarFile().getName() + " contains an invalid " + "processIf" + " tag. It must contain major, minor, and micro, " + " and each must have zero or a positive" + " integer value. Ignoring contents of block."));
            return;
        }
        setDescription = atts.getValue("setDescription");
        boolean newVersionIncluded = atts.getValue("setMajor") != null || atts.getValue("setMinor") != null || atts.getValue("setMicro") != null || setDescription != null;
        try {
            if (newVersionIncluded) {
                setMajor = Integer.parseInt(atts.getValue("setMajor"));
                setMinor = Integer.parseInt(atts.getValue("setMinor"));
                setMicro = Integer.parseInt(atts.getValue("setMicro"));
                if (setMajor < 0 || setMinor < 0 || setMicro < 0 || setDescription == null) {
                    throw new IllegalArgumentException();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("The deployment descriptor META-INF/comp.xml in " + this.ctx.getJarFile().getName() + " contains an invalid " + "processIf" + " tag. If it contains setMajor, setMinor, setMicro," + " or setDescription attributes it must contain all four" + " and each of the first three must have zero or a" + " positive integer value. Ignoring contents of block."));
            return;
        }
        String testType = atts.getValue("version");
        if (testType == null) {
            testType = EQU;
        }
        if (!(testType.equals(EQU) || testType.equals(LESS_THAN) || testType.equals(LESS_THAN_OR_EQU) || testType.equals(GTR_THAN) || testType.equals(GTR_THAN_OR_EQU) || testType.equals(NOT_EQU))) {
            log.error((Object)("The deployment descriptor META-INF/comp.xml in " + this.ctx.getJarFile().getName() + " contains an invalid " + "processIf" + " tag. If it contains an 'version' attribute the" + " value of that attribute must be one of '" + EQU + "', '" + NOT_EQU + "', '" + GTR_THAN + "', '" + GTR_THAN_OR_EQU + "', '" + LESS_THAN + "', or '" + LESS_THAN_OR_EQU + "'. Ignoring contents of block."));
            return;
        }
        String fname = atts.getValue("fname");
        if (fname == null || fname.equals("")) {
            log.error((Object)("The deployment descriptor META-INF/comp.xml in " + this.ctx.getJarFile().getName() + " contains an invalid " + "processIf" + " tag. It must contain a non-empty 'fname' attribute" + " holding the functional name whose version is being" + " tested. Ignoring contents of block."));
            return;
        }
        this.enabled = this.evaluate(testType, fname, major, minor, micro);
        if (this.enabled && newVersionIncluded) {
            VersionsManager vMgr = VersionsManager.getInstance();
            this.enabled = vMgr.setVersion(fname, setDescription, setMajor, setMinor, setMicro);
        }
    }

    private boolean evaluate(String testType, String fname, int major, int minor, int micro) {
        VersionsManager vMgr = VersionsManager.getInstance();
        Version currVer = vMgr.getVersion(fname);
        Version testVer = new Version(fname, "", major, minor, micro);
        if (currVer == null) {
            return true;
        }
        if (testType.equals(EQU)) {
            return currVer.equalTo(testVer);
        }
        if (testType.equals(NOT_EQU)) {
            return !currVer.equalTo(testVer);
        }
        if (testType.equals(GTR_THAN)) {
            return currVer.greaterThan(testVer);
        }
        if (testType.equals(GTR_THAN_OR_EQU)) {
            return currVer.greaterThan(testVer) || currVer.equalTo(testVer);
        }
        if (testType.equals(LESS_THAN)) {
            return currVer.lessThan(testVer);
        }
        if (testType.equals(LESS_THAN_OR_EQU)) {
            return currVer.lessThan(testVer) || currVer.equalTo(testVer);
        }
        return false;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.enabled) {
            this.routingHandler.startElement(namespaceURI, localName, qName, atts);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.enabled) {
            this.routingHandler.endElement(namespaceURI, localName, qName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.enabled) {
            this.routingHandler.characters(ch, start, length);
        }
    }
}

