/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.channel.dao.jpa;

import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang.Validate;
import org.jasig.portal.channel.IChannelDefinition;
import org.jasig.portal.channel.IChannelType;
import org.jasig.portal.channel.dao.IChannelDefinitionDao;
import org.jasig.portal.channel.dao.jpa.ChannelDefinitionImpl;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class JpaChannelDefinitionDao
implements IChannelDefinitionDao {
    private static final String FIND_ALL_CHANNEL_DEFS = "from ChannelDefinitionImpl channel";
    private static final String FIND_CHANNEL_DEF_BY_FNAME = "from ChannelDefinitionImpl channel where channel.fname = :fname";
    private static final String FIND_CHANNEL_DEF_BY_NAME = "from ChannelDefinitionImpl channel where channel.name = :name";
    private static final String FIND_ALL_CHANNEL_DEFS_CACHE_REGION = ChannelDefinitionImpl.class.getName() + ".query.FIND_ALL_CHANNEL_DEFS";
    private static final String FIND_CHANNEL_DEF_BY_FNAME_CACHE_REGION = ChannelDefinitionImpl.class.getName() + ".query.FIND_CHANNEL_DEF_BY_FNAME";
    private static final String FIND_CHANNEL_DEF_BY_NAME_CACHE_REGION = ChannelDefinitionImpl.class.getName() + ".query.FIND_CHANNEL_DEF_BY_NAME";
    private EntityManager entityManager;

    @PersistenceContext
    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    @Transactional
    public IChannelDefinition createChannelDefinition(IChannelType channelType, String fname, String clazz, String name, String title) {
        Validate.notNull((Object)channelType, (String)"channelType can not be null");
        Validate.notEmpty((String)fname, (String)"fname can not be null");
        Validate.notEmpty((String)clazz, (String)"clazz can not be null");
        Validate.notEmpty((String)name, (String)"name can not be null");
        Validate.notEmpty((String)title, (String)"title can not be null");
        ChannelDefinitionImpl channelDefinition = new ChannelDefinitionImpl(channelType, fname, clazz, name, title);
        this.entityManager.persist((Object)channelDefinition);
        return channelDefinition;
    }

    @Override
    @Transactional
    public void deleteChannelDefinition(IChannelDefinition definition) {
        Validate.notNull((Object)definition, (String)"definition can not be null");
        IChannelDefinition persistentChannelDefinition = this.entityManager.contains((Object)definition) ? definition : (IChannelDefinition)this.entityManager.merge((Object)definition);
        this.entityManager.remove((Object)persistentChannelDefinition);
    }

    @Override
    public List<IChannelDefinition> getChannelDefinitions() {
        Query query = this.entityManager.createQuery(FIND_ALL_CHANNEL_DEFS);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)FIND_ALL_CHANNEL_DEFS_CACHE_REGION);
        List channelDefinitions = query.getResultList();
        return channelDefinitions;
    }

    @Override
    public IChannelDefinition getChannelDefinition(int id) {
        return (IChannelDefinition)this.entityManager.find(ChannelDefinitionImpl.class, (Object)id);
    }

    @Override
    public IChannelDefinition getChannelDefinition(String fname) {
        Query query = this.entityManager.createQuery(FIND_CHANNEL_DEF_BY_FNAME);
        query.setParameter("fname", (Object)fname);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)FIND_CHANNEL_DEF_BY_FNAME_CACHE_REGION);
        query.setMaxResults(1);
        List channelDefinitions = query.getResultList();
        IChannelDefinition definition = (IChannelDefinition)DataAccessUtils.uniqueResult((Collection)channelDefinitions);
        return definition;
    }

    @Override
    public IChannelDefinition getChannelDefinitionByName(String name) {
        Query query = this.entityManager.createQuery(FIND_CHANNEL_DEF_BY_NAME);
        query.setParameter("name", (Object)name);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)FIND_CHANNEL_DEF_BY_NAME_CACHE_REGION);
        query.setMaxResults(1);
        List channelDefinitions = query.getResultList();
        IChannelDefinition definition = (IChannelDefinition)DataAccessUtils.uniqueResult((Collection)channelDefinitions);
        return definition;
    }

    @Override
    @Transactional
    public IChannelDefinition updateChannelDefinition(IChannelDefinition definition) {
        Validate.notNull((Object)definition, (String)"definition can not be null");
        this.entityManager.persist((Object)definition);
        return definition;
    }
}

